/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.filemanager.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.AgentFileFingerprint;
import org.netxms.nxmc.base.widgets.LabeledText;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileFingerprintDialog
extends Dialog {
    private AgentFileFingerprint fp;

    public FileFingerprintDialog(Shell parent, AgentFileFingerprint fp) {
        super(parent);
        this.fp = fp;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.addField(dialogArea, "File size (in bytes)", Long.toString(this.fp.getSize()), false);
        this.addField(dialogArea, "CRC32", Long.toHexString(this.fp.getCRC32()), false);
        this.addField(dialogArea, "MD5", FileFingerprintDialog.hexString((byte[])this.fp.getMD5()), false);
        this.addField(dialogArea, "SHA256", FileFingerprintDialog.hexString((byte[])this.fp.getSHA256()), false);
        byte[] data = this.fp.getFileData();
        if (data != null && data.length > 0) {
            StringBuilder sb = new StringBuilder();
            int offset = 0;
            while (offset < data.length) {
                int b;
                sb.append(String.format(" %04X  ", offset));
                char[] text = new char[16];
                for (b = 0; b < 16 && offset < data.length; ++b, ++offset) {
                    byte ch = data[offset];
                    int ub = ch & 0xFF;
                    if (ub < 16) {
                        sb.append('0');
                    }
                    sb.append(Integer.toHexString(ub));
                    sb.append(' ');
                    text[b] = (char)(ch < 32 || ch >= 127 ? 46 : (char)ch);
                }
                while (b < 16) {
                    sb.append("   ");
                    text[b] = 32;
                    ++b;
                }
                sb.append("  ");
                sb.append(text);
                sb.append(" \n");
            }
            this.addField(dialogArea, String.format("First %d bytes of file", data.length), sb.toString(), true);
        }
        return dialogArea;
    }

    private void addField(Composite parent, String name, String value, boolean multiline) {
        LabeledText text = multiline ? new LabeledText(parent, 0, 2050) : new LabeledText(parent, 0);
        text.setLabel(name);
        text.setEditable(false);
        text.setText(value);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.getTextControl().setFont(JFaceResources.getTextFont());
    }

    private static String hexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            int ub = b & 0xFF;
            if (ub < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(ub));
        }
        return sb.toString();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("File Fingerprint");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Close", true);
    }
}

