/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logwatch.widgets;

import java.util.Arrays;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.base.widgets.DashboardComposite;
import org.netxms.nxmc.base.widgets.ImageHyperlink;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.base.widgets.events.IHyperlinkListener;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.logwatch.widgets.LogParserEditor;
import org.netxms.nxmc.modules.logwatch.widgets.LogParserFileEditor;
import org.netxms.nxmc.modules.logwatch.widgets.helpers.LogParserFile;
import org.netxms.nxmc.modules.logwatch.widgets.helpers.LogParserType;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class LogParserFileEditor
extends DashboardComposite {
    private final I18n i18n = LocalizationHelper.getI18n(LogParserFileEditor.class);
    private LogParserFile file;
    private LogParserEditor editor;
    private Combo comboFileEncoding;
    private LabeledText labelFileName;
    private Button checkPreallocated;
    private Button checkSnapshot;
    private Button checkKeepOpen;
    private Button checkIgnoreModificationTime;
    private Button checkRescan;
    private Button checkFollowSymlinks;
    private Button checkRemoveEscapeSequences;

    public LogParserFileEditor(Composite parent, LogParserFile file, LogParserEditor editor) {
        super(parent, 2048);
        this.file = file;
        this.editor = editor;
        this.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        this.setLayout((Layout)layout);
        this.labelFileName = new LabeledText((Composite)this, 0);
        this.labelFileName.setLabel("File path");
        this.labelFileName.setBackground(this.getBackground());
        this.labelFileName.setText(file != null ? file.getFile() : "");
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.labelFileName.setLayoutData((Object)gd);
        this.labelFileName.getTextControl().addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        String[] items = new String[]{"AUTO", "ACP", "UTF-8", "UCS-2", "UCS-2LE", "UCS-2BE", "UCS-4", "UCS-4LE", "UCS-4BE"};
        gd = new GridData();
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalAlignment = 4;
        this.comboFileEncoding = WidgetHelper.createLabeledCombo((Composite)this, (int)2056, (String)this.i18n.tr("File encoding"), (Object)gd);
        this.comboFileEncoding.setItems(items);
        this.comboFileEncoding.select(file != null && file.getEncoding() != null ? Arrays.asList(items).indexOf(file.getEncoding()) : 0);
        this.comboFileEncoding.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite controlBar = new Composite((Composite)this, 0);
        controlBar.setLayout((Layout)new RowLayout(256));
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        controlBar.setLayoutData((Object)gd);
        this.fillControlBar(controlBar);
        Composite checkboxBar = new Composite((Composite)this, 0);
        GridLayout checkboxBarLayout = new GridLayout();
        checkboxBarLayout.numColumns = 2;
        checkboxBarLayout.makeColumnsEqualWidth = true;
        checkboxBar.setLayout((Layout)checkboxBarLayout);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 16384;
        checkboxBar.setLayoutData((Object)gd);
        3 checkboxSelectionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.checkPreallocated = new Button(checkboxBar, 32);
        this.checkPreallocated.setBackground(this.getBackground());
        this.checkPreallocated.setText(this.i18n.tr("&Preallocated"));
        this.checkPreallocated.setSelection(file.getPreallocated());
        this.checkPreallocated.addSelectionListener((SelectionListener)checkboxSelectionListener);
        this.checkSnapshot = new Button(checkboxBar, 32);
        this.checkSnapshot.setBackground(this.getBackground());
        this.checkSnapshot.setText(this.i18n.tr("Use &snapshot"));
        this.checkSnapshot.setSelection(file.getSnapshot());
        this.checkSnapshot.addSelectionListener((SelectionListener)checkboxSelectionListener);
        this.checkKeepOpen = new Button(checkboxBar, 32);
        this.checkKeepOpen.setBackground(this.getBackground());
        this.checkKeepOpen.setText(this.i18n.tr("&Keep open"));
        this.checkKeepOpen.setSelection(file.getKeepOpen());
        this.checkKeepOpen.addSelectionListener((SelectionListener)checkboxSelectionListener);
        this.checkIgnoreModificationTime = new Button(checkboxBar, 32);
        this.checkIgnoreModificationTime.setBackground(this.getBackground());
        this.checkIgnoreModificationTime.setText(this.i18n.tr("Ignore &modification time"));
        this.checkIgnoreModificationTime.setSelection(file.getIgnoreModificationTime());
        this.checkIgnoreModificationTime.addSelectionListener((SelectionListener)checkboxSelectionListener);
        this.checkRescan = new Button(checkboxBar, 32);
        this.checkRescan.setBackground(this.getBackground());
        this.checkRescan.setText(this.i18n.tr("&Rescan"));
        this.checkRescan.setSelection(file.getRescan());
        this.checkRescan.addSelectionListener((SelectionListener)checkboxSelectionListener);
        this.checkFollowSymlinks = new Button(checkboxBar, 32);
        this.checkFollowSymlinks.setBackground(this.getBackground());
        this.checkFollowSymlinks.setText(this.i18n.tr("&Follow symlinks"));
        this.checkFollowSymlinks.setSelection(file.getFollowSymlinks());
        this.checkFollowSymlinks.addSelectionListener((SelectionListener)checkboxSelectionListener);
        this.checkRemoveEscapeSequences = new Button(checkboxBar, 32);
        this.checkRemoveEscapeSequences.setBackground(this.getBackground());
        this.checkRemoveEscapeSequences.setText(this.i18n.tr("Remove &escape sequences"));
        this.checkRemoveEscapeSequences.setSelection(file.getRemoveEscapeSequences());
        this.checkRemoveEscapeSequences.addSelectionListener((SelectionListener)checkboxSelectionListener);
    }

    private void fillControlBar(Composite parent) {
        ImageHyperlink link = new ImageHyperlink(parent, 0);
        link.setImage(SharedIcons.IMG_DELETE_OBJECT);
        link.setToolTipText(this.i18n.tr("Delete"));
        link.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void save() {
        this.file.setFile(this.labelFileName.getText().trim());
        this.file.setEncoding(this.comboFileEncoding.getSelectionIndex() == 0 ? null : this.comboFileEncoding.getText());
        this.file.setPreallocated(this.checkPreallocated.getSelection());
        this.file.setSnapshot(this.checkSnapshot.getSelection());
        this.file.setKeepOpen(this.checkKeepOpen.getSelection());
        this.file.setIgnoreModificationTime(this.checkIgnoreModificationTime.getSelection());
        this.file.setRescan(this.checkRescan.getSelection());
        this.file.setFollowSymlinks(this.checkFollowSymlinks.getSelection());
        this.file.setRemoveEscapeSequences(this.checkRemoveEscapeSequences.getSelection());
    }

    public LogParserType getParserType() {
        return this.editor.getParserType();
    }

    public String getFile() {
        return this.labelFileName.getText();
    }
}

