/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.DateTimeSelector;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class MaintanenceScheduleDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(MaintanenceScheduleDialog.class);
    private Date startDate;
    private Date endDate;
    private String comments;
    private DateTimeSelector startDateSelector;
    private DateTimeSelector endDateSelector;
    private Label labelStartDate;
    private Label labelEndDate;
    private LabeledText commentsEditor;

    public MaintanenceScheduleDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Schedule Maintenance"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.labelStartDate = new Label(dialogArea, 0);
        this.labelStartDate.setText(this.i18n.tr("Start time"));
        this.startDateSelector = new DateTimeSelector(dialogArea, 0);
        this.startDateSelector.setValue(new Date());
        this.startDateSelector.setToolTipText(this.i18n.tr("Start time"));
        this.labelEndDate = new Label(dialogArea, 0);
        this.labelEndDate.setText(this.i18n.tr("End time"));
        this.endDateSelector = new DateTimeSelector(dialogArea, 0);
        this.endDateSelector.setValue(new Date());
        this.endDateSelector.setToolTipText(this.i18n.tr("End time"));
        this.commentsEditor = new LabeledText(dialogArea, 0);
        this.commentsEditor.setLabel(this.i18n.tr("Comments"));
        this.commentsEditor.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        return dialogArea;
    }

    protected void okPressed() {
        this.startDate = this.startDateSelector.getValue();
        this.endDate = this.endDateSelector.getValue();
        this.comments = this.commentsEditor.getText();
        if (this.startDate.after(this.endDate)) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Start time must be earlier than end time!"));
            return;
        }
        super.okPressed();
    }

    public Date getStartTime() {
        return this.startDate;
    }

    public Date getEndTime() {
        return this.endDate;
    }

    public String getComments() {
        return this.comments;
    }
}

