/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.NetworkMap;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptEditor;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.xnap.commons.i18n.I18n;

public class MapObjectFilter
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(MapObjectFilter.class);
    private NetworkMap map;
    private Button checkboxEnableFilter;
    private ScriptEditor filterSource;
    private String initialFilter;
    private boolean initialEnable;

    public MapObjectFilter(AbstractObject object) {
        super(LocalizationHelper.getI18n(MapObjectFilter.class).tr("Object Filter"), object);
    }

    public String getId() {
        return "map-object-filter";
    }

    public boolean isVisible() {
        return this.object instanceof NetworkMap;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.map = (NetworkMap)this.object;
        this.initialFilter = this.map.getFilter();
        this.initialEnable = (this.map.getFlags() & 0x20) != 0;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkboxEnableFilter = new Button(dialogArea, 32);
        this.checkboxEnableFilter.setText(this.i18n.tr("Filter objects"));
        this.checkboxEnableFilter.setSelection(this.initialEnable);
        this.checkboxEnableFilter.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Label label = new Label(dialogArea, 0);
        label.setText(this.i18n.tr("Filtering script"));
        GridData gd = new GridData();
        gd.verticalIndent = 5;
        label.setLayoutData((Object)gd);
        this.filterSource = new ScriptEditor(dialogArea, 2048, 768, "Variables:\n\t$object\tcurrent object\n\t$node\tcurrent object if it's class is Node\n\nReturn value: true to include current object into this map");
        this.filterSource.setText(this.initialFilter);
        this.filterSource.setEnabled(this.initialEnable);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.filterSource.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        String filter = this.filterSource.getText();
        if (this.initialFilter.equals(filter) && this.checkboxEnableFilter.getSelection() == this.initialEnable) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setFilter(filter);
        md.setObjectFlags(this.checkboxEnableFilter.getSelection() ? 32L : 0L, 32L);
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }
}

