/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.PortStopEntry;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Zone;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.PortStopEntryDialog;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.propertypages.PortStopList;
import org.xnap.commons.i18n.I18n;

public class PortStopList
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(PortStopList.class);
    private List<PortStopEntry> entries = new ArrayList();
    private TableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private boolean isModified = false;

    public PortStopList(AbstractObject object) {
        super(LocalizationHelper.getI18n(PortStopList.class).tr("Port Stop List"), object);
    }

    public String getId() {
        return "portStopList";
    }

    public int getPriority() {
        return 40;
    }

    public boolean isVisible() {
        return this.object instanceof Zone || this.object instanceof Container || this.object instanceof Subnet || this.object instanceof Node;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.viewer = new TableViewer(dialogArea, 67586);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        column.setText(this.i18n.tr("Port"));
        column.setWidth(100);
        column = new TableColumn(table, 16384);
        column.setText(this.i18n.tr("Protocol"));
        column.setWidth(100);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PortStopEntryLabelProvider(this));
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite buttons = new Composite(dialogArea, 0);
        GridLayout buttonsLayout = new GridLayout();
        buttonsLayout.verticalSpacing = 4;
        buttonsLayout.marginHeight = 0;
        buttons.setLayout((Layout)buttonsLayout);
        gd = new GridData();
        gd.verticalAlignment = 128;
        buttons.setLayoutData((Object)gd);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(this.i18n.tr("&Add..."));
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.widthHint = 90;
        this.addButton.setLayoutData((Object)gd);
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(this.i18n.tr("&Edit..."));
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.widthHint = 90;
        this.editButton.setLayoutData((Object)gd);
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText(this.i18n.tr("&Delete"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.widthHint = 90;
        this.deleteButton.setLayoutData((Object)gd);
        this.entries.clear();
        this.entries.addAll(this.object.getPortStopList());
        this.viewer.setInput((Object)this.entries.toArray());
        return dialogArea;
    }

    private void addEntry() {
        PortStopEntryDialog dlg = new PortStopEntryDialog(this.getShell(), null);
        if (dlg.open() == 0) {
            this.entries.add(dlg.getEntry());
            this.viewer.setInput((Object)this.entries.toArray());
            this.isModified = true;
        }
    }

    private void editEntry() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        PortStopEntry entry = (PortStopEntry)selection.getFirstElement();
        PortStopEntryDialog dlg = new PortStopEntryDialog(this.getShell(), entry);
        if (dlg.open() == 0) {
            this.viewer.refresh();
            this.isModified = true;
        }
    }

    private void deleteEntries() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        for (Object o : selection.toList()) {
            this.entries.remove(o);
        }
        this.viewer.setInput((Object)this.entries.toArray());
        this.isModified = true;
    }

    protected boolean applyChanges(boolean isApply) {
        if (!this.isModified) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setPortStopList(this.entries);
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.entries.clear();
        this.viewer.setInput((Object)this.entries.toArray());
        this.isModified = true;
    }
}

