/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages.helpers;

import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.AccessListElement;
import org.netxms.client.NXCSession;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.modules.objects.propertypages.helpers.AccessListLabelProvider;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.resources.ThemeEngine;

public class AccessListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private static final AccessBit[] ACCESS_BITS = new AccessBit[]{new AccessBit(1, 'R'), new AccessBit(65536, 'a'), new AccessBit(131072, 's'), new AccessBit(2, 'M'), new AccessBit(0x200000, 'M'), new AccessBit(0x800000, 'r'), new AccessBit(4, 'C'), new AccessBit(0x400000, 'u'), new AccessBit(8, 'D'), new AccessBit(256, 'O'), new AccessBit(128, 'E'), new AccessBit(16, 'V'), new AccessBit(64, 'K'), new AccessBit(512, 'T'), new AccessBit(2048, 'I'), new AccessBit(1024, 'P'), new AccessBit(32, 'A'), new AccessBit(4096, 'N'), new AccessBit(8192, 'U'), new AccessBit(16384, 'F'), new AccessBit(0x100000, 'c'), new AccessBit(262144, 'S'), new AccessBit(32768, 'M'), new AccessBit(524288, 'J'), new AccessBit(0x1000000, 'Y'), new AccessBit(0x2000000, 'i')};
    private final NXCSession session = Registry.getSession();
    private final Color inheritedElementColor = ThemeEngine.getForegroundColor((String)"List.DisabledItem");

    public Image getColumnImage(Object element, int columnIndex) {
        int userId;
        AbstractUserObject userObject;
        if (columnIndex == 0 && element instanceof AccessListElement && (userObject = this.session.findUserDBObjectById(userId = ((AccessListElement)element).getUserId(), null)) != null) {
            return userObject instanceof User ? SharedIcons.IMG_USER : SharedIcons.IMG_GROUP;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                int userId = ((AccessListElement)element).getUserId();
                AbstractUserObject userObject = this.session.findUserDBObjectById(userId, null);
                return userObject != null ? userObject.getName() : "[" + userId + "]";
            }
            case 1: {
                AccessListElement e = (AccessListElement)element;
                StringBuilder sb = new StringBuilder(32);
                for (int i = 0; i < ACCESS_BITS.length; ++i) {
                    sb.append((e.getAccessRights() & AccessListLabelProvider.ACCESS_BITS[i].mask) != 0 ? AccessListLabelProvider.ACCESS_BITS[i].symbol : (char)'-');
                }
                return sb.toString();
            }
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        return ((AccessListElement)element).isInherited() ? this.inheritedElementColor : null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }
}

