/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.elements;

import java.util.HashMap;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ConnectionPointType;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.client.topology.ConnectionPoint;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.CommandTextBox;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.elements.OverviewPageElement;
import org.xnap.commons.i18n.I18n;

public class Topology
extends OverviewPageElement {
    private final I18n i18n = LocalizationHelper.getI18n(Topology.class);
    private Action actionFindSwitchPort;
    private CommandTextBox commandBox;
    private HashMap<Long, ConnectionPoint> connectionPointCache = new HashMap();

    public Topology(Composite parent, OverviewPageElement anchor, ObjectView objectView) {
        super(parent, anchor, objectView);
        this.createActionButtons();
    }

    private void createActionButtons() {
        NXCSession session = Registry.getSession();
        this.actionFindSwitchPort = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected String getTitle() {
        return this.i18n.tr("Topology");
    }

    protected void onObjectChange() {
        this.commandBox.deleteAll(false);
        long objectId = this.getObject().getObjectId();
        NXCSession session = Registry.getSession();
        if (this.connectionPointCache.containsKey(objectId)) {
            ConnectionPoint cp = (ConnectionPoint)this.connectionPointCache.get(objectId);
            if (cp != null) {
                this.showConnectionStep2(session, cp);
            } else {
                this.commandBox.addOrUpdate(this.actionFindSwitchPort, this.i18n.tr("Connection point cannot be found"), false);
            }
        } else {
            this.commandBox.addOrUpdate(this.actionFindSwitchPort, this.i18n.tr("Connection point information not retrieved yet"), false);
        }
        this.commandBox.rebuild();
    }

    public void showConnectionStep(ConnectionPoint cp) {
        if (cp == null) {
            this.commandBox.addOrUpdate(this.actionFindSwitchPort, this.i18n.tr("Connection point cannot be found"), false);
            return;
        }
        NXCSession session = Registry.getSession();
        if (session.areChildrenSynchronized(cp.getNodeId()) && session.areChildrenSynchronized(cp.getLocalNodeId())) {
            this.showConnectionStep2(session, cp);
        } else {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private void showConnectionStep2(NXCSession session, ConnectionPoint cp) {
        Node bridge = (Node)session.findObjectById(cp.getNodeId(), Node.class);
        AbstractObject iface = session.findObjectById(cp.getInterfaceId());
        AbstractObject localInterface = session.findObjectById(cp.getLocalInterfaceId());
        if (bridge != null && iface != null) {
            if (this.getObject() instanceof Node) {
                if (cp.getType() == ConnectionPointType.WIRELESS) {
                    this.commandBox.addOrUpdate(this.actionFindSwitchPort, String.format(this.i18n.tr("Connected to wireless access point %2$s radio %3$s via local interface %1$s"), localInterface.getObjectName(), bridge.getObjectName(), iface.getObjectName()), false);
                } else {
                    this.commandBox.addOrUpdate(this.actionFindSwitchPort, cp.getType() == ConnectionPointType.DIRECT ? String.format(this.i18n.tr("Directly connected to network switch %2$s port %3$s via local interface %1$s"), localInterface.getObjectName(), bridge.getObjectName(), iface.getObjectName()) : String.format(this.i18n.tr("Indirectly connected to network switch %2$s port %3$s via local interface %1$s"), localInterface.getObjectName(), bridge.getObjectName(), iface.getObjectName()), false);
                }
            } else if (cp.getType() == ConnectionPointType.WIRELESS) {
                this.commandBox.addOrUpdate(this.actionFindSwitchPort, String.format(this.i18n.tr("Connected to wireless access point %1$s radio %2$s"), bridge.getObjectName(), iface.getObjectName()), false);
            } else {
                this.commandBox.addOrUpdate(this.actionFindSwitchPort, cp.getType() == ConnectionPointType.DIRECT ? String.format(this.i18n.tr("Directly connected to network switch %1$s port %2$s"), bridge.getObjectName(), iface.getObjectName()) : String.format(this.i18n.tr("Indirectly connected to network switch %1$s port %2$s"), bridge.getObjectName(), iface.getObjectName()), false);
            }
        } else if (cp.getType() == ConnectionPointType.UNKNOWN) {
            this.commandBox.addOrUpdate(this.actionFindSwitchPort, this.i18n.tr("Connection point cannot be found"), false);
        }
    }

    protected Control createClientArea(Composite parent) {
        this.commandBox = new CommandTextBox(parent, 0);
        return this.commandBox;
    }

    public boolean isApplicableForObject(AbstractObject object) {
        return object instanceof Node || object instanceof Interface || object instanceof AccessPoint;
    }
}

