/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.client.NXCSession;
import org.netxms.client.topology.ArpCacheEntry;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;

public class ArpCacheFilter
extends ViewerFilter
implements AbstractViewerFilter {
    private NXCSession session = Registry.getSession();
    private String filterString = null;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        ArpCacheEntry e = (ArpCacheEntry)element;
        if (e.getMacAddress().toString().toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (e.getIpAddress().getHostAddress().contains(this.filterString)) {
            return true;
        }
        if (e.getInterfaceName().toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (e.getNodeId() != 0L && this.session.getObjectName(e.getNodeId()).toLowerCase().contains(this.filterString)) {
            return true;
        }
        String vendor = this.session.getVendorByMac(e.getMacAddress(), null);
        return vendor != null && vendor.toLowerCase().contains(this.filterString);
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString.toLowerCase();
    }
}

