/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.InetAddressListElement;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class AddressListLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private I18n i18n = LocalizationHelper.getI18n(AddressListLabelProvider.class);
    private NXCSession session = Registry.getSession();
    private boolean isDiscoveryTarget;

    public AddressListLabelProvider(boolean isDiscoveryTarget) {
        this.isDiscoveryTarget = isDiscoveryTarget;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        InetAddressListElement e = (InetAddressListElement)element;
        switch (columnIndex) {
            case 0: {
                return e.getType() == 0 ? e.getBaseAddress().getHostAddress() + "/" + e.getMaskBits() : e.getBaseAddress().getHostAddress() + " - " + e.getEndAddress().getHostAddress();
            }
            case 1: {
                return this.isDiscoveryTarget ? this.session.getZoneName(e.getZoneUIN()) : e.getComment();
            }
            case 2: {
                return e.getProxyId() != 0L ? this.session.getObjectName(e.getProxyId()) : this.i18n.tr("Zone proxy");
            }
            case 3: {
                return e.getComment();
            }
        }
        return null;
    }
}

