/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.users.dialogs;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.users.TwoFactorAuthenticationMethod;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.users.dialogs.helpers.AbstractMethodBindingConfigurator;
import org.netxms.nxmc.modules.users.dialogs.helpers.CustomMethodBindingConfigurator;
import org.netxms.nxmc.modules.users.dialogs.helpers.MessageMethodBindingConfigurator;
import org.netxms.nxmc.modules.users.dialogs.helpers.TOTPMethodBindingConfigurator;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class TwoFactorAuthMethodEditDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(TwoFactorAuthMethodEditDialog.class);
    private String name;
    private Map<String, String> configuration;
    private Map<String, TwoFactorAuthenticationMethod> availableMethods = new HashMap();
    private Set<String> configuredMethods;
    private Combo methodSelector;
    private Composite configurationArea;
    private AbstractMethodBindingConfigurator methodConfigurator;

    public TwoFactorAuthMethodEditDialog(Shell parentShell, String name, Map<String, String> configuration, Set<String> configuredMethods) {
        super(parentShell);
        this.name = name;
        this.configuration = configuration != null ? new HashMap<String, String>(configuration) : null;
        this.configuredMethods = configuredMethods;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.name != null ? this.i18n.tr("Edit Two-Factor Authentication Method") : this.i18n.tr("Add Two-Factor Authentication Method"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.methodSelector = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)12, (String)"Method", (Object)new GridData(4, 0x1000000, true, false));
        this.methodSelector.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.readMethodList();
        if (this.name != null) {
            this.methodSelector.setEnabled(false);
        }
        this.configurationArea = new Composite(dialogArea, 0);
        this.configurationArea.setLayout((Layout)new FillLayout());
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumWidth = 600;
        this.configurationArea.setLayoutData((Object)gd);
        return dialogArea;
    }

    private void readMethodList() {
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createConfigurator(String driver) {
        if (this.methodConfigurator != null) {
            this.methodConfigurator.dispose();
        }
        this.methodConfigurator = driver.equals("TOTP") ? new TOTPMethodBindingConfigurator(this.configurationArea) : (driver.equals("Message") ? new MessageMethodBindingConfigurator(this.configurationArea) : new CustomMethodBindingConfigurator(this.configurationArea));
        this.getShell().layout(true, true);
        this.getShell().pack();
        if (this.configuration != null) {
            this.methodConfigurator.setConfiguration(this.configuration);
        }
    }

    protected void okPressed() {
        int index = this.methodSelector.getSelectionIndex();
        if (index == -1) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)this.i18n.tr("Error"), (String)this.i18n.tr("Authentication method not selected!"));
            return;
        }
        this.name = this.methodSelector.getItem(index);
        this.configuration = this.methodConfigurator != null ? this.methodConfigurator.getConfiguration() : new HashMap(0);
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }
}

