/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.views;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewNotRestoredException;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class NonRestorableView
extends View {
    private static final Logger logger = LoggerFactory.getLogger(NonRestorableView.class);
    private final I18n i18n = LocalizationHelper.getI18n(NonRestorableView.class);
    private String viewName;
    private Exception exception;
    private Action actionShowDetails;

    public NonRestorableView(Exception exception, String viewName) {
        super(viewName, ResourceManager.getImageDescriptor((String)"icons/invalid-report.png"), viewName);
        this.viewName = viewName;
        this.exception = exception;
    }

    protected NonRestorableView() {
        super(LocalizationHelper.getI18n(NonRestorableView.class).tr("Not Restored"), ResourceManager.getImageDescriptor((String)"icons/invalid-report.png"), null);
    }

    protected void createContent(Composite parent) {
        Text text = new Text(parent, 522);
        text.setFont(JFaceResources.getTextFont());
        text.setText(this.exception != null ? this.exception.getLocalizedMessage() : this.i18n.tr("View cannot be restored (internal error)"));
        this.actionShowDetails = new /* Unavailable Anonymous Inner Class!! */;
    }

    private static void appendExceptionTrace(StringBuilder sb, Throwable e) {
        sb.append(e.getClass().getName());
        if (e.getMessage() != null && !e.getMessage().isBlank()) {
            sb.append(": ");
            sb.append(e.getMessage());
        }
        sb.append('\n');
        for (StackTraceElement s : e.getStackTrace()) {
            sb.append("\tat ");
            sb.append(s.toString());
            sb.append('\n');
        }
        if (e.getCause() != null) {
            sb.append("Caused by: ");
            NonRestorableView.appendExceptionTrace((StringBuilder)sb, (Throwable)e.getCause());
        }
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionShowDetails);
        super.fillLocalToolBar(manager);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionShowDetails);
        super.fillLocalMenu(manager);
    }

    public void saveState(Memento memento) {
        super.saveState(memento);
        memento.set("viewName", this.viewName);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.exception);
            oos.close();
            memento.set("exception", Base64.getEncoder().encodeToString(baos.toByteArray()));
        }
        catch (IOException e) {
            logger.error("Unexpected serialization error", (Throwable)e);
        }
    }

    public void restoreState(Memento memento) throws ViewNotRestoredException {
        super.restoreState(memento);
        this.viewName = memento.getAsString("viewName");
        String e = memento.getAsString("exception", null);
        if (e != null) {
            byte[] data = Base64.getDecoder().decode(e);
            try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));){
                this.exception = (Exception)ois.readObject();
            }
            catch (IOException | ClassNotFoundException e1) {
                logger.error("Unexpected deserialization error", (Object)e);
            }
        }
    }
}

