/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.ai.widgets;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.ai.AiMessage;
import org.netxms.client.constants.AiMessageStatus;
import org.netxms.nxmc.base.widgets.MarkdownViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.ai.widgets.AiMessageContentPanel;
import org.netxms.nxmc.resources.SharedIcons;
import org.xnap.commons.i18n.I18n;

public class AiMessageContentPanel
extends Composite {
    private final I18n i18n = LocalizationHelper.getI18n(AiMessageContentPanel.class);
    private static final int AUTO_READ_DELAY_MS = 30000;
    private AiMessage currentMessage;
    private Label titleLabel;
    private MarkdownViewer contentViewer;
    private Composite buttonArea;
    private Button approveButton;
    private Button rejectButton;
    private AiMessageActionHandler actionHandler;
    private Runnable autoReadRunnable;

    public AiMessageContentPanel(Composite parent, int style, AiMessageActionHandler actionHandler) {
        super(parent, style);
        this.actionHandler = actionHandler;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        Composite headerArea = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        headerArea.setLayout((Layout)layout);
        headerArea.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.titleLabel = new Label(headerArea, 0);
        this.titleLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.headerfont"));
        this.titleLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label spacer = new Label(headerArea, 0);
        GridData gd = new GridData();
        gd.widthHint = 20;
        spacer.setLayoutData((Object)gd);
        this.buttonArea = new Composite(headerArea, 0);
        GridLayout buttonLayout = new GridLayout(2, true);
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        this.buttonArea.setLayout((Layout)buttonLayout);
        this.buttonArea.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.approveButton = new Button(this.buttonArea, 8);
        this.approveButton.setImage(SharedIcons.IMG_APPROVE);
        this.approveButton.setText(this.i18n.tr("Approve"));
        this.approveButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.widthHint = 90;
        this.approveButton.setLayoutData((Object)gd);
        this.rejectButton = new Button(this.buttonArea, 8);
        this.rejectButton.setImage(SharedIcons.IMG_REJECT);
        this.rejectButton.setText(this.i18n.tr("Reject"));
        this.rejectButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.widthHint = 90;
        this.rejectButton.setLayoutData((Object)gd);
        this.buttonArea.setVisible(false);
        ((GridData)this.buttonArea.getLayoutData()).exclude = true;
        new Label((Composite)this, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.contentViewer = new MarkdownViewer((Composite)this, 0);
        this.contentViewer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.showPlaceholder();
    }

    private void showPlaceholder() {
        this.titleLabel.setText(this.i18n.tr("Select a message to view its content"));
        this.contentViewer.setText("");
    }

    public void setMessage(AiMessage message) {
        this.cancelAutoReadTimer();
        this.currentMessage = message;
        if (message == null) {
            this.showPlaceholder();
            this.setButtonsVisible(false);
            return;
        }
        this.titleLabel.setText(message.getTitle());
        this.contentViewer.setText(message.getText());
        boolean showButtons = message.isApprovalRequest() && (message.getStatus() == AiMessageStatus.PENDING || message.getStatus() == AiMessageStatus.READ);
        System.out.println(message);
        this.setButtonsVisible(showButtons);
        if (message.getStatus() == AiMessageStatus.PENDING) {
            this.scheduleAutoRead(message.getId());
        }
        this.layout(true, true);
    }

    private void scheduleAutoRead(long messageId) {
        this.autoReadRunnable = () -> {
            if (!this.isDisposed() && this.currentMessage != null && this.currentMessage.getId() == messageId && this.currentMessage.getStatus() == AiMessageStatus.PENDING && this.actionHandler != null) {
                this.actionHandler.markMessageAsRead(this.currentMessage);
            }
        };
        this.getDisplay().timerExec(30000, this.autoReadRunnable);
    }

    private void cancelAutoReadTimer() {
        if (this.autoReadRunnable != null) {
            this.getDisplay().timerExec(-1, this.autoReadRunnable);
            this.autoReadRunnable = null;
        }
    }

    private void setButtonsVisible(boolean visible) {
        this.buttonArea.setVisible(visible);
        ((GridData)this.buttonArea.getLayoutData()).exclude = !visible;
        this.layout(true, true);
    }

    public AiMessage getCurrentMessage() {
        return this.currentMessage;
    }

    public void updateMessage(AiMessage message) {
        if (this.currentMessage != null && this.currentMessage.getId() == message.getId()) {
            this.setMessage(message);
        }
    }
}

