/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.assetmanagement;

import java.util.List;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Asset;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.Rack;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.base.widgets.MessageAreaHolder;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.actions.ObjectAction;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class LinkAssetToObjectAction
extends ObjectAction<Asset> {
    private final I18n i18n = LocalizationHelper.getI18n(LinkAssetToObjectAction.class);

    public LinkAssetToObjectAction(ViewPlacement viewPlacement, ISelectionProvider selectionProvider) {
        super(Asset.class, LocalizationHelper.getI18n(LinkAssetToObjectAction.class).tr("&Link to..."), viewPlacement, selectionProvider);
        this.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/link-objects.png"));
    }

    protected void run(List<Asset> objects) {
        ObjectSelectionDialog dlg;
        NXCSession session = Registry.getSession();
        Asset asset = objects.get(0);
        if (asset.getLinkedObjectId() != 0L) {
            String question = String.format(this.i18n.tr("Asset \"%s\" already linked to object \"%s\". Are you sure you want to link it another object?"), asset.getObjectName(), session.getObjectName(asset.getLinkedObjectId()));
            if (!MessageDialogHelper.openConfirm((Shell)this.getShell(), (String)this.i18n.tr("Confirm Link"), (String)question)) {
                return;
            }
        }
        if ((dlg = new ObjectSelectionDialog(this.getShell(), ObjectSelectionDialog.createDataCollectionTargetSelectionFilter())).open() != 0) {
            return;
        }
        AbstractObject object = (AbstractObject)dlg.getSelectedObjects().get(0);
        if (!(object instanceof Rack) && !(object instanceof DataCollectionTarget) || object instanceof Cluster) {
            return;
        }
        if (object.getAssetId() != 0L) {
            String question = String.format(this.i18n.tr("\"%s\" object already linked to \"%s\" asset. Are you sure you want to link it another asset?"), object.getObjectName(), session.getObjectName(object.getAssetId()));
            if (!MessageDialogHelper.openConfirm((Shell)this.getShell(), (String)this.i18n.tr("Confirm Link"), (String)question)) {
                return;
            }
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isValidForSelection(IStructuredSelection selection) {
        return selection.size() == 1 && selection.getFirstElement() instanceof Asset;
    }

    static /* synthetic */ MessageAreaHolder access$000(LinkAssetToObjectAction x0) {
        return x0.getMessageArea();
    }
}

