/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.DataCollectionObjectListener;
import org.netxms.nxmc.modules.datacollection.TableColumnEnumerator;
import org.xnap.commons.i18n.I18n;

public class DataCollectionObjectEditor {
    private final I18n i18n = LocalizationHelper.getI18n(DataCollectionObjectEditor.class);
    private DataCollectionObject object;
    private long sourceNode;
    private Runnable timer;
    private Set<DataCollectionObjectListener> listeners = new HashSet();
    private TableColumnEnumerator tableColumnEnumerator;

    public DataCollectionObjectEditor(DataCollectionObject object) {
        this.object = object;
        this.timer = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void doObjectModification() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void modify() {
        Display.getCurrent().timerExec(-1, this.timer);
        Display.getCurrent().timerExec(200, this.timer);
    }

    public void addListener(DataCollectionObjectListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(DataCollectionObjectListener listener) {
        this.listeners.remove(listener);
    }

    public void fireOnSelectItemListeners(DataOrigin origin, String name, String description, DataType dataType) {
        for (DataCollectionObjectListener l : this.listeners) {
            l.onSelectItem(origin, name, description, dataType);
        }
    }

    public void fireOnSelectTableListeners(DataOrigin origin, String name, String description) {
        for (DataCollectionObjectListener l : this.listeners) {
            l.onSelectTable(origin, name, description);
        }
    }

    public DataCollectionObject getObject() {
        return this.object;
    }

    public DataCollectionItem getObjectAsItem() {
        return (DataCollectionItem)this.object;
    }

    public DataCollectionTable getObjectAsTable() {
        return (DataCollectionTable)this.object;
    }

    public TableColumnEnumerator getTableColumnEnumerator() {
        return this.tableColumnEnumerator;
    }

    public void setTableColumnEnumerator(TableColumnEnumerator enumerator) {
        this.tableColumnEnumerator = enumerator;
    }

    public void setSourceNode(long nodeId) {
        this.sourceNode = nodeId;
    }

    public long getSourceNode() {
        return this.sourceNode;
    }

    public static String createModificationWarningMessage(DataCollectionObject dco) {
        I18n i18n = LocalizationHelper.getI18n(DataCollectionObjectEditor.class);
        String message = null;
        if (dco.getTemplateId() == dco.getNodeId()) {
            message = i18n.tr("This DCI was added by instance discovery\nAll local changes can be overwritten at any moment");
        } else if (dco.getTemplateId() != 0L) {
            AbstractObject object = Registry.getSession().findObjectById(dco.getTemplateId());
            message = object != null ? String.format(object.getObjectClass() == 14 ? i18n.tr("This DCI was added by cluster \"%s\"\nAll local changes can be overwritten at any moment") : i18n.tr("This DCI was added by template \"%s\"\nAll local changes can be overwritten at any moment"), object.getObjectName()) : String.format(i18n.tr("This DCI was added by unknown object with ID %d\nAll local changes can be overwritten at any moment"), dco.getTemplateId());
        }
        return message;
    }
}

