/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.WebServiceDefinition;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.propertypages.PropertyDialog;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.propertypages.WebServiceGeneral;
import org.netxms.nxmc.modules.datacollection.propertypages.WebServiceHeaders;
import org.netxms.nxmc.modules.datacollection.views.WebServiceManager;
import org.netxms.nxmc.modules.datacollection.views.helpers.WebServiceDefinitionComparator;
import org.netxms.nxmc.modules.datacollection.views.helpers.WebServiceDefinitionFilter;
import org.netxms.nxmc.modules.datacollection.views.helpers.WebServiceDefinitionLabelProvider;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class WebServiceManager
extends ConfigurationView {
    private final I18n i18n = LocalizationHelper.getI18n(WebServiceManager.class);
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_URL = 1;
    public static final int COLUMN_METHOD = 2;
    public static final int COLUMN_AUTHENTICATION = 3;
    public static final int COLUMN_LOGIN = 4;
    public static final int COLUMN_RETENTION_TIME = 5;
    public static final int COLUMN_TIMEOUT = 6;
    public static final int COLUMN_DESCRIPTION = 7;
    private Map<Integer, WebServiceDefinition> webServiceDefinitions = new HashMap();
    private int nameCounter = 1;
    private WebServiceDefinitionFilter filter;
    private SortableTableViewer viewer;
    private Action actionCreate;
    private Action actionEdit;
    private Action actionDelete;

    public WebServiceManager() {
        super(LocalizationHelper.getI18n(WebServiceManager.class).tr("Web Service Definitions"), SharedIcons.URL, "configuration.web-services", true);
    }

    public void createContent(Composite parent) {
        String[] names = new String[]{this.i18n.tr("Name"), this.i18n.tr("URL"), this.i18n.tr("Method"), this.i18n.tr("Authentication"), this.i18n.tr("Login"), this.i18n.tr("Retention Time"), this.i18n.tr("Timeout"), this.i18n.tr("Description")};
        int[] widths = new int[]{300, 600, 100, 100, 160, 90, 90, 600};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WebServiceDefinitionLabelProvider());
        this.viewer.setComparator((ViewerComparator)new WebServiceDefinitionComparator());
        this.filter = new WebServiceDefinitionFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"WebServiceManager");
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.refresh();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void createActions() {
        this.actionCreate = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+N", (IAction)this.actionCreate);
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEdit.setEnabled(false);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete.setEnabled(false);
        this.addKeyBinding("M1+D", (IAction)this.actionDelete);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCreate);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
    }

    public void refresh() {
        NXCSession session = Registry.getSession();
        8 job = new /* Unavailable Anonymous Inner Class!! */;
        job.start();
    }

    private void createDefinition() {
        WebServiceDefinition definition;
        if (this.showDefinitionEditDialog(definition = new WebServiceDefinition("Web Service " + Integer.toString(this.nameCounter++)))) {
            NXCSession session = Registry.getSession();
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private void editDefinition() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        WebServiceDefinition definition = (WebServiceDefinition)selection.getFirstElement();
        if (this.showDefinitionEditDialog(definition)) {
            NXCSession session = Registry.getSession();
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private boolean showDefinitionEditDialog(WebServiceDefinition definition) {
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("general", (IPreferencePage)new WebServiceGeneral(definition)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("headers", (IPreferencePage)new WebServiceHeaders(definition)));
        PropertyDialog dlg = new PropertyDialog(this.getWindow().getShell(), pm, this.i18n.tr("Edit Web Service Definition"));
        return dlg.open() == 0;
    }

    private void deleteDefinitions() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Delete Web Service Definitions"), (String)this.i18n.tr("Selected web service definitions will be permanently deleted. Are you sure?"))) {
            return;
        }
        int[] deleteList = new int[selection.size()];
        int index = 0;
        for (Object o : selection.toList()) {
            deleteList[index++] = ((WebServiceDefinition)o).getId();
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

