/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.incidents.widgets.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.NXCSession;
import org.netxms.client.events.IncidentSummary;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;

public class IncidentComparator
extends ViewerComparator {
    private NXCSession session = Registry.getSession();

    public int compare(Viewer viewer, Object e1, Object e2) {
        IncidentSummary i1 = (IncidentSummary)e1;
        IncidentSummary i2 = (IncidentSummary)e2;
        int column = (Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID");
        int result = switch (column) {
            case 0 -> Long.compare(i1.getId(), i2.getId());
            case 1 -> Integer.compare(i1.getState().getValue(), i2.getState().getValue());
            case 2 -> i1.getTitle().compareToIgnoreCase(i2.getTitle());
            case 3 -> this.session.getObjectName(i1.getSourceObjectId()).compareToIgnoreCase(this.session.getObjectName(i2.getSourceObjectId()));
            case 4 -> this.getUserName(i1.getAssignedUserId()).compareToIgnoreCase(this.getUserName(i2.getAssignedUserId()));
            case 5 -> i1.getCreationTime().compareTo(i2.getCreationTime());
            case 6 -> i1.getLastChangeTime().compareTo(i2.getLastChangeTime());
            case 7 -> Integer.compare(i1.getAlarmCount(), i2.getAlarmCount());
            default -> 0;
        };
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }

    private String getUserName(int userId) {
        AbstractUserObject user = this.session.findUserDBObjectById(userId, null);
        return user != null ? user.getName() : "";
    }
}

