/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logviewer.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.TableRow;
import org.netxms.client.log.Log;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.logviewer.views.helpers.LogLabelProvider;
import org.xnap.commons.i18n.I18n;

public class NotificationLogRecordDetailsDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(NotificationLogRecordDetailsDialog.class);
    private TableRow record;
    private Log logHandle;
    private LabeledText timestamp;
    private LabeledText status;
    private LabeledText channel;
    private LabeledText recipient;
    private LabeledText subject;
    private LabeledText eventCode;
    private LabeledText eventId;
    private LabeledText ruleId;
    private LabeledText message;
    private LogLabelProvider labelProvider;

    public NotificationLogRecordDetailsDialog(Shell parentShell, TableRow record, Log logHandle) {
        super(parentShell);
        this.logHandle = logHandle;
        this.record = record;
        this.labelProvider = new LogLabelProvider(logHandle, null);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Notification"));
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.i18n.tr("Close"), true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.timestamp = new LabeledText(dialogArea, 0);
        this.timestamp.setLabel(this.i18n.tr("Timestamp"));
        this.timestamp.setText(this.labelProvider.getColumnText((Object)this.record, this.logHandle.getColumnIndex("notification_timestamp")));
        this.timestamp.setEditable(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.timestamp.setLayoutData((Object)gd);
        this.channel = new LabeledText(dialogArea, 0);
        this.channel.setLabel(this.i18n.tr("Channel"));
        this.channel.setText(this.labelProvider.getColumnText((Object)this.record, this.logHandle.getColumnIndex("notification_channel")));
        this.channel.setEditable(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.channel.setLayoutData((Object)gd);
        this.status = new LabeledText(dialogArea, 0);
        this.status.setLabel(this.i18n.tr("Status"));
        this.status.setText(this.labelProvider.getColumnText((Object)this.record, this.logHandle.getColumnIndex("success")));
        this.status.setEditable(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.status.setLayoutData((Object)gd);
        this.recipient = new LabeledText(dialogArea, 0);
        this.recipient.setLabel(this.i18n.tr("Recipient"));
        this.recipient.setText(this.labelProvider.getColumnText((Object)this.record, this.logHandle.getColumnIndex("recipient")));
        this.recipient.setEditable(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.recipient.setLayoutData((Object)gd);
        this.subject = new LabeledText(dialogArea, 0);
        this.subject.setLabel(this.i18n.tr("Subject"));
        this.subject.setText(this.labelProvider.getColumnText((Object)this.record, this.logHandle.getColumnIndex("subject")));
        this.subject.setEditable(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.subject.setLayoutData((Object)gd);
        this.eventCode = new LabeledText(dialogArea, 0);
        this.eventCode.setLabel(this.i18n.tr("Event type"));
        this.eventCode.setText(this.labelProvider.getColumnText((Object)this.record, this.logHandle.getColumnIndex("event_code")));
        this.eventCode.setEditable(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.eventCode.setLayoutData((Object)gd);
        this.eventId = new LabeledText(dialogArea, 0);
        this.eventId.setLabel(this.i18n.tr("Event ID"));
        this.eventId.setText(this.labelProvider.getColumnText((Object)this.record, this.logHandle.getColumnIndex("event_id")));
        this.eventId.setEditable(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.eventId.setLayoutData((Object)gd);
        this.ruleId = new LabeledText(dialogArea, 0);
        this.ruleId.setLabel(this.i18n.tr("Rule ID"));
        this.ruleId.setText(this.labelProvider.getColumnText((Object)this.record, this.logHandle.getColumnIndex("rule_id")));
        this.ruleId.setEditable(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.ruleId.setLayoutData((Object)gd);
        this.message = new LabeledText(dialogArea, 0, 2818);
        this.message.setLabel(this.i18n.tr("Message"));
        this.message.setFont(JFaceResources.getTextFont());
        this.message.setText(this.labelProvider.getColumnText((Object)this.record, this.logHandle.getColumnIndex("message")));
        this.message.setEditable(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 600;
        gd.heightHint = 300;
        gd.horizontalSpan = 3;
        this.message.setLayoutData((Object)gd);
        return dialogArea;
    }

    public boolean close() {
        this.labelProvider.dispose();
        return super.close();
    }
}

