/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logviewer.widgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Scrollable;
import org.netxms.client.constants.ColumnFilterSetOperation;
import org.netxms.client.log.ColumnFilter;
import org.netxms.client.log.Log;
import org.netxms.client.log.LogColumn;
import org.netxms.client.log.LogFilter;
import org.netxms.client.log.OrderingColumn;
import org.netxms.nxmc.base.widgets.ImageHyperlink;
import org.netxms.nxmc.base.widgets.Section;
import org.netxms.nxmc.base.widgets.events.IHyperlinkListener;
import org.netxms.nxmc.base.widgets.helpers.ExpansionListener;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.logviewer.widgets.ColumnFilterEditor;
import org.netxms.nxmc.modules.logviewer.widgets.helpers.ColumnSelectionHandler;
import org.netxms.nxmc.modules.logviewer.widgets.helpers.OrderingColumnEditingSupport;
import org.netxms.nxmc.modules.logviewer.widgets.helpers.OrderingListLabelProvider;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class FilterBuilder
extends Composite {
    private final I18n i18n = LocalizationHelper.getI18n(FilterBuilder.class);
    private Log logHandle = null;
    private Map<String, ColumnFilterEditor> columns = new HashMap();
    private List<OrderingColumn> orderingColumns = new ArrayList();
    private ScrolledComposite scroller;
    private Composite content;
    private Section condition;
    private Section ordering;
    private ImageHyperlink addColumnLink;
    private TableViewer orderingList;
    private Menu columnSelectionMenu = null;

    public FilterBuilder(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.scroller = new ScrolledComposite((Composite)this, 512);
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
        this.scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.content = new Composite((Composite)this.scroller, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.content.setLayout((Layout)layout);
        this.content.setBackground(this.content.getDisplay().getSystemColor(25));
        this.scroller.setContent((Control)this.content);
        this.createConditionSection();
        this.createOrderingSection();
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = this.content.computeSize(wHint, hHint, changed);
        if (size.y > 600) {
            size.y = 600;
        }
        return size;
    }

    private void createConditionSection() {
        this.condition = new Section(this.content, this.i18n.tr("Condition"), true);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        this.condition.setLayoutData((Object)gd);
        this.condition.addExpansionListener((ExpansionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite clientArea = this.condition.getClient();
        GridLayout layout = new GridLayout();
        clientArea.setLayout((Layout)layout);
        this.addColumnLink = new ImageHyperlink(clientArea, 0);
        this.addColumnLink.setText(this.i18n.tr("Add column"));
        this.addColumnLink.setImage(SharedIcons.IMG_ADD_OBJECT);
        this.addColumnLink.setBackground(clientArea.getBackground());
        this.addColumnLink.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createOrderingSection() {
        this.ordering = new Section(this.content, this.i18n.tr("Ordering"), true);
        GridData gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.widthHint = 400;
        this.ordering.setLayoutData((Object)gd);
        this.ordering.addExpansionListener((ExpansionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite clientArea = this.ordering.getClient();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        this.orderingList = new TableViewer(clientArea, 68354);
        TableViewerColumn column = new TableViewerColumn(this.orderingList, 16384);
        column.getColumn().setText(this.i18n.tr("Column"));
        column.getColumn().setWidth(200);
        column = new TableViewerColumn(this.orderingList, 16384);
        column.getColumn().setText(this.i18n.tr("Descending"));
        column.getColumn().setWidth(60);
        column.setEditingSupport((EditingSupport)new OrderingColumnEditingSupport((ColumnViewer)this.orderingList));
        this.orderingList.getTable().setLinesVisible(true);
        this.orderingList.getTable().setHeaderVisible(true);
        this.orderingList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.orderingList.setLabelProvider((IBaseLabelProvider)new OrderingListLabelProvider());
        this.orderingList.setInput((Object)this.orderingColumns.toArray());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 2;
        this.orderingList.getControl().setLayoutData((Object)gd);
        ImageHyperlink linkAdd = new ImageHyperlink(clientArea, 0);
        linkAdd.setText(this.i18n.tr("Add"));
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        linkAdd.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        ImageHyperlink linkRemove = new ImageHyperlink(clientArea, 0);
        linkRemove.setText(this.i18n.tr("Remove"));
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        linkRemove.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.setEnabled(false);
        this.orderingList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void clearFilter() {
        this.orderingColumns.clear();
        this.orderingList.setInput((Object)this.orderingColumns.toArray());
        for (ColumnFilterEditor e : this.columns.values()) {
            e.dispose();
        }
        this.columns.clear();
        this.updateLayout();
    }

    public void addOrderingColumn(LogColumn column, boolean descending) {
        OrderingColumn orderingColumn = new OrderingColumn(column);
        if (!this.orderingColumns.contains(orderingColumn)) {
            orderingColumn.setDescending(descending);
            this.orderingColumns.add(orderingColumn);
            this.orderingList.setInput((Object)this.orderingColumns.toArray());
        }
    }

    private void addOrderingColumn() {
        this.createColumnSelectionMenu((ColumnSelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void removeSortingColumn() {
        IStructuredSelection selection = (IStructuredSelection)this.orderingList.getSelection();
        for (Object o : selection.toList()) {
            this.orderingColumns.remove(o);
        }
        this.orderingList.setInput((Object)this.orderingColumns.toArray());
        this.updateLayout();
    }

    public void setLogHandle(Log logHandle) {
        this.logHandle = logHandle;
        this.updateLayout();
    }

    private void addColumnToFilter(Control lastControl) {
        this.createColumnSelectionMenu((ColumnSelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createColumnFilterEditor(LogColumn column, Control lastControl, ColumnFilter initialFilter) {
        ColumnFilterEditor editor = new ColumnFilterEditor(this.condition.getClient(), column, initialFilter != null ? initialFilter.getOperation() : ColumnFilterSetOperation.AND, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        editor.attachFilterBuilder(this, initialFilter);
        editor.moveAbove(lastControl);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        editor.setLayoutData((Object)gd);
        this.columns.put(column.getName(), editor);
    }

    private void createColumnSelectionMenu(ColumnSelectionHandler handler) {
        if (this.logHandle == null) {
            return;
        }
        if (this.columnSelectionMenu != null) {
            this.columnSelectionMenu.dispose();
        }
        this.columnSelectionMenu = new Menu((Decorations)this.getShell(), 8);
        this.getShell().setMenu(this.columnSelectionMenu);
        for (LogColumn lc : this.logHandle.getColumns()) {
            MenuItem item = new MenuItem(this.columnSelectionMenu, 8);
            item.setText(lc.getDescription());
            item.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.columnSelectionMenu.addMenuListener((MenuListener)new /* Unavailable Anonymous Inner Class!! */);
        this.columnSelectionMenu.setVisible(true);
    }

    public LogFilter createFilter() {
        LogFilter filter = new LogFilter();
        for (Map.Entry e : this.columns.entrySet()) {
            ColumnFilter cf = ((ColumnFilterEditor)e.getValue()).buildFilterTree();
            if (cf == null) continue;
            filter.setColumnFilter((String)e.getKey(), cf);
        }
        filter.setOrderingColumns(new ArrayList(this.orderingColumns));
        return filter;
    }

    public void updateLayout() {
        this.getParent().layout(true, true);
        this.scroller.setMinSize(this.content.computeSize(this.scroller.getSize().x, -1));
    }

    public void setFilter(LogFilter filter) {
        this.clearFilter();
        for (Map.Entry cf : filter.getColumnFilters()) {
            this.createColumnFilterEditor(this.logHandle.getColumn((String)cf.getKey()), (Control)this.addColumnLink, (ColumnFilter)cf.getValue());
        }
        this.orderingColumns.addAll(filter.getOrderingColumns());
        this.orderingList.setInput((Object)this.orderingColumns.toArray());
        this.updateLayout();
    }
}

