/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.maps.LinkDataLocation;
import org.netxms.client.maps.configs.MapDataSource;
import org.netxms.client.maps.configs.MapLinkDataSource;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledCombo;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.widgets.DciSelector;
import org.netxms.nxmc.modules.networkmaps.views.helpers.LinkEditor;
import org.xnap.commons.i18n.I18n;

public class DataSourceEditDlg
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(DataSourceEditDlg.class);
    private MapDataSource dci;
    private DciSelector dciSelector;
    private LabeledCombo locationSelector;
    private LabeledText instance;
    private LabeledText dataColumn;
    private LabeledText formatString;
    private LinkEditor linkEditor;
    private String dciDescription;

    public DataSourceEditDlg(Shell parentShell, MapDataSource dci, LinkEditor linkEditor) {
        super(parentShell);
        this.dci = dci;
        this.linkEditor = linkEditor;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Edit Data Source"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.dciSelector = new DciSelector(dialogArea, 0);
        this.dciSelector.setLabel(this.i18n.tr("Data collection item"));
        this.dciSelector.setDciId(this.dci.getNodeId(), this.dci.getDciId());
        this.dciSelector.setDcObjectType(this.dci.getType());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 400;
        gd.horizontalSpan = 2;
        this.dciSelector.setLayoutData((Object)gd);
        this.formatString = new LabeledText(dialogArea, 0);
        this.formatString.setLabel(this.i18n.tr("Format string"));
        this.formatString.setText(this.dci.getFormatString());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.formatString.setLayoutData((Object)gd);
        if (this.dci.getType() == 2) {
            Group tableGroup = new Group(dialogArea, 0);
            tableGroup.setText(this.i18n.tr("Table cell"));
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            tableGroup.setLayoutData((Object)gd);
            layout = new GridLayout();
            tableGroup.setLayout((Layout)layout);
            this.dataColumn = new LabeledText((Composite)tableGroup, 0);
            this.dataColumn.setLabel(this.i18n.tr("Data column"));
            this.dataColumn.setText(this.dci.getColumn());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.dataColumn.setLayoutData((Object)gd);
            this.instance = new LabeledText((Composite)tableGroup, 0);
            this.instance.setLabel(this.i18n.tr("Instance"));
            this.instance.setText(this.dci.getInstance());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.instance.setLayoutData((Object)gd);
        }
        if (this.dci instanceof MapLinkDataSource) {
            NXCSession session = Registry.getSession();
            this.locationSelector = new LabeledCombo(dialogArea, 0);
            this.locationSelector.setLabel(this.i18n.tr("Position on the link"));
            this.locationSelector.add(this.i18n.tr("Center"));
            this.locationSelector.add(session.getObjectNameWithAlias(this.linkEditor.getElement1()));
            this.locationSelector.add(session.getObjectNameWithAlias(this.linkEditor.getElement2()));
            this.locationSelector.select(((MapLinkDataSource)this.dci).getLocation().getValue());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.locationSelector.setLayoutData((Object)gd);
        }
        return dialogArea;
    }

    protected void okPressed() {
        if (!(!(this.dci instanceof MapLinkDataSource) || this.dci.getNodeId() == this.dciSelector.getNodeId() && this.dci.getDciId() == this.dciSelector.getDciId() && this.dci.getFormatString().equals(this.formatString.getText()) && (this.dci.getType() != 2 || this.dci.getColumn().equals(this.dataColumn.getText().trim()) && this.dci.getInstance().equals(this.instance.getText())) && ((MapLinkDataSource)this.dci).getLocation() == LinkDataLocation.getByValue((int)this.locationSelector.getSelectionIndex()))) {
            ((MapLinkDataSource)this.dci).setSystem(false);
        }
        this.dci.setNodeId(this.dciSelector.getNodeId());
        this.dci.setDciId(this.dciSelector.getDciId());
        this.dciDescription = this.dciSelector.getDciDescription();
        this.dci.setFormatString(this.formatString.getText());
        if (this.dci.getType() == 2) {
            this.dci.setColumn(this.dataColumn.getText().trim());
            this.dci.setInstance(this.instance.getText());
        }
        if (this.dci instanceof MapLinkDataSource) {
            ((MapLinkDataSource)this.dci).setLocation(LinkDataLocation.getByValue((int)this.locationSelector.getSelectionIndex()));
        }
        super.okPressed();
    }

    public String getDciDescription() {
        return this.dciDescription;
    }
}

