/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Chassis;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class Communication
extends ObjectPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(Communication.class);
    private AbstractNode node;
    private LabeledText primaryName;
    private Button externalGateway;
    private Button enablePingOnPrimaryIP;
    private boolean primaryNameChanged = false;
    private Chassis chassis;
    private ObjectSelector controllerNode;
    private Button bindUnderController;

    public Communication(AbstractObject object) {
        super(LocalizationHelper.getI18n(Communication.class).tr("Communication"), object);
    }

    public String getId() {
        return "communication";
    }

    public int getPriority() {
        return 10;
    }

    public boolean isVisible() {
        return this.object instanceof DataCollectionTarget && !(this.object instanceof Cluster);
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout dialogLayout = new GridLayout();
        dialogLayout.marginWidth = 0;
        dialogLayout.marginHeight = 0;
        dialogArea.setLayout((Layout)dialogLayout);
        if (this.object instanceof AbstractNode) {
            this.node = (AbstractNode)this.object;
            this.primaryName = new LabeledText(dialogArea, 0);
            this.primaryName.setLabel(this.i18n.tr("Primary host name"));
            this.primaryName.setText(this.node.getPrimaryName());
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.primaryName.setLayoutData((Object)gd);
            this.primaryName.getTextControl().addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
            this.externalGateway = new Button(dialogArea, 32);
            this.externalGateway.setText(this.i18n.tr("Communication through external gateway"));
            this.externalGateway.setSelection((this.node.getFlags() & 0x10000) != 0);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.externalGateway.setLayoutData((Object)gd);
            this.enablePingOnPrimaryIP = new Button(dialogArea, 32);
            this.enablePingOnPrimaryIP.setText(this.i18n.tr("Use ICMP ping on primary IP address to determine node status"));
            this.enablePingOnPrimaryIP.setSelection(this.node.isPingOnPrimaryIPEnabled());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.enablePingOnPrimaryIP.setLayoutData((Object)gd);
        } else if (this.object instanceof Chassis) {
            this.chassis = (Chassis)this.object;
            this.controllerNode = new ObjectSelector(dialogArea, 0, true);
            this.controllerNode.setLabel(this.i18n.tr("Controller"));
            this.controllerNode.setObjectId(this.chassis.getControllerId());
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.controllerNode.setLayoutData((Object)gd);
            this.bindUnderController = new Button(dialogArea, 32);
            this.bindUnderController.setText(this.i18n.tr("&Bind chassis object under controller node object"));
            this.bindUnderController.setSelection((this.chassis.getFlags() & 0x10000) != 0);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.bindUnderController.setLayoutData((Object)gd);
        }
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        if (this.node != null) {
            return this.applyNodeChanges(isApply);
        }
        if (this.chassis != null) {
            return this.applyChassisChanges(isApply);
        }
        return true;
    }

    private boolean applyNodeChanges(boolean isApply) {
        NXCObjectModificationData md = new NXCObjectModificationData(this.node.getObjectId());
        if (this.primaryNameChanged) {
            String hostName = this.primaryName.getText().trim();
            if (!hostName.matches("^(([A-Za-z0-9_-]+\\.)*[A-Za-z0-9_-]+|[A-Fa-f0-9:]+)$")) {
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)String.format(this.i18n.tr("String \"%s\" is not a valid host name or IP address. Please enter valid host name or IP address as primary host name."), hostName));
                return false;
            }
            md.setPrimaryName(hostName);
        }
        if (isApply) {
            this.setValid(false);
        }
        int flags = this.node.getFlags();
        flags = this.externalGateway.getSelection() ? (flags |= 0x10000) : (flags &= 0xFFFEFFFF);
        flags = this.enablePingOnPrimaryIP.getSelection() ? (flags |= 0x4000000) : (flags &= 0xFBFFFFFF);
        md.setObjectFlags((long)flags, 0x4010000L);
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    private boolean applyChassisChanges(boolean isApply) {
        NXCObjectModificationData md = new NXCObjectModificationData(this.chassis.getObjectId());
        if (isApply) {
            this.setValid(false);
        }
        int flags = this.chassis.getFlags();
        flags = this.bindUnderController.getSelection() ? (flags |= 0x10000) : (flags &= 0xFFFEFFFF);
        md.setObjectFlags((long)flags, 65536L);
        md.setControllerId(this.controllerNode.getObjectId());
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.node != null) {
            this.externalGateway.setSelection(false);
            this.enablePingOnPrimaryIP.setSelection(false);
        }
    }
}

