/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.netxms.client.DeviceViewElement;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.widgets.DeviceViewWidget;
import org.netxms.nxmc.tools.ColorCache;
import org.netxms.nxmc.tools.ColorConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class DeviceViewWidget
extends Canvas {
    private static final Logger logger = LoggerFactory.getLogger(DeviceViewWidget.class);
    private final I18n i18n = LocalizationHelper.getI18n(DeviceViewWidget.class);
    private View view;
    private long nodeId;
    private List<DeviceViewElement> elements;
    private Map<String, ImageHandle> images = new HashMap();
    private ColorCache colors;
    private Runnable sizeChangeListener = null;

    public DeviceViewWidget(Composite parent, int style, View view) {
        super(parent, style);
        this.view = view;
        this.colors = new ColorCache((Control)this);
        this.addPaintListener((PaintListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void paintElement(GC gc, DeviceViewElement element) {
        Image image;
        if ((element.flags & 1) != 0) {
            gc.setBackground(this.colors.create(ColorConverter.rgbFromInt((int)element.backgroundColor)));
            gc.fillRectangle(element.x, element.y, element.width, element.height);
        }
        if ((element.flags & 2) != 0) {
            gc.setForeground(this.colors.create(ColorConverter.rgbFromInt((int)element.borderColor)));
            gc.drawRectangle(element.x, element.y, element.width, element.height);
        }
        if (element.imageName != null && (image = this.getDeviceViewImage(element.imageName)) != null) {
            gc.drawImage(image, 0, 0, image.getImageData().width, image.getImageData().height, element.x, element.y, element.width, element.height);
        }
        if (element.commands != null) {
            String[] commands;
            for (String c : commands = element.commands.split(";")) {
                try {
                    this.executeDrawingCommand(gc, c.trim(), element.x, element.y);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void executeDrawingCommand(GC gc, String command, int baseX, int baseY) throws Exception {
        switch (command.charAt(0)) {
            case 'B': {
                int[] args = DeviceViewWidget.extractIntArguments((String)command.substring(1));
                if (args.length != 3) break;
                gc.setBackground(this.colors.create(args[0], args[1], args[2]));
                break;
            }
            case 'C': {
                boolean fill = command.charAt(1) == 'F';
                int[] args = DeviceViewWidget.extractIntArguments((String)command.substring(fill ? 2 : 1));
                if (args.length != 3) break;
                if (fill) {
                    gc.fillOval(args[0] - args[2] / 2 + baseX, args[1] - args[2] / 2 + baseY, args[2], args[2]);
                }
                gc.drawOval(args[0] - args[2] / 2 + baseX, args[1] - args[2] / 2 + baseY, args[2], args[2]);
                break;
            }
            case 'F': {
                int[] args = DeviceViewWidget.extractIntArguments((String)command.substring(1));
                if (args.length != 3) break;
                gc.setForeground(this.colors.create(args[0], args[1], args[2]));
                break;
            }
            case 'I': {
                this.drawImage(gc, command.substring(1), baseX, baseY);
                break;
            }
            case 'L': {
                int[] args = DeviceViewWidget.extractIntArguments((String)command.substring(1));
                if (args.length != 4) break;
                gc.drawLine(args[0] + baseX, args[1] + baseY, args[2] + baseX, args[3] + baseY);
                break;
            }
            case 'R': {
                boolean fill = command.charAt(1) == 'F';
                int[] args = DeviceViewWidget.extractIntArguments((String)command.substring(fill ? 2 : 1));
                if (args.length != 4) break;
                if (fill) {
                    gc.fillRectangle(args[0] + baseX, args[1] + baseY, args[2], args[3]);
                }
                gc.drawRectangle(args[0] + baseX, args[1] + baseY, args[2], args[3]);
                break;
            }
            case 'T': {
                DeviceViewWidget.drawText((GC)gc, (String)command.substring(1), (int)baseX, (int)baseY);
            }
        }
    }

    private static void drawText(GC gc, String data, int baseX, int baseY) {
        String[] parts = data.trim().split(",", 3);
        if (parts.length < 3) {
            return;
        }
        int x = Integer.parseInt(parts[0]) + baseX;
        int y = Integer.parseInt(parts[1]) + baseY;
        gc.drawText(parts[2], x, y, true);
    }

    private void drawImage(GC gc, String data, int baseX, int baseY) {
        String[] parts = data.trim().split(",", 3);
        if (parts.length < 3) {
            return;
        }
        Image image = this.getDeviceViewImage(parts[2]);
        if (image == null) {
            return;
        }
        int x = Integer.parseInt(parts[0]) + baseX;
        int y = Integer.parseInt(parts[1]) + baseY;
        gc.drawImage(image, x, y);
    }

    private static int[] extractIntArguments(String data) throws NumberFormatException {
        String[] parts = data.trim().split(",");
        int[] args = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            args[i] = Integer.parseInt(parts[i].trim());
        }
        return args;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (this.elements == null || this.elements.isEmpty()) {
            return super.computeSize(wHint, hHint, changed);
        }
        return DeviceViewWidget.sizeFromElementList((List)this.elements);
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
        this.refresh();
    }

    public void refresh() {
        if (this.nodeId != 0L) {
            NXCSession session = Registry.getSession();
            3 job = new /* Unavailable Anonymous Inner Class!! */;
            job.setUser(false);
            job.start();
        } else if (this.elements != null) {
            this.elements = null;
            if (this.sizeChangeListener != null) {
                this.sizeChangeListener.run();
            }
            this.redraw();
        }
    }

    public void setSizeChangeListener(Runnable listener) {
        this.sizeChangeListener = listener;
    }

    private static Point sizeFromElementList(List<DeviceViewElement> elements) {
        if (elements == null || elements.isEmpty()) {
            return new Point(0, 0);
        }
        DeviceViewElement e = elements.get(0);
        return new Point(e.width, e.height);
    }

    private Image getDeviceViewImage(String name) {
        ImageHandle h = (ImageHandle)this.images.get(name);
        if (h == null) {
            return null;
        }
        if (h.image == null && !h.failed) {
            try {
                h.image = new Image((Device)this.getDisplay(), (InputStream)new ByteArrayInputStream(h.imageData));
            }
            catch (Exception e) {
                logger.debug("Cannot create image \"" + name + "\" from binary data", (Throwable)e);
                h.failed = true;
            }
        }
        return h.image;
    }
}

