/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.dialogs;

import java.io.Serializable;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.NotificationChannel;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class NotificationChannelPropertiesDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(NotificationChannelPropertiesDialog.class);
    private NotificationChannel nc;
    private LabeledText textName;
    private LabeledText textDescription;
    private LabeledText textConfiguraiton;
    private Combo comboDriverName;
    private boolean customName;

    public NotificationChannelPropertiesDialog(Shell parentShell, NotificationChannel nc) {
        super(parentShell);
        this.nc = nc;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.comboDriverName = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)this.i18n.tr("Driver"), (Object)gd);
        this.comboDriverName.addModifyListener((ModifyListener & Serializable)listener -> {
            int selectionIndex = this.comboDriverName.getSelectionIndex();
            if (selectionIndex != -1 && !this.customName) {
                this.textName.setText(this.comboDriverName.getItem(selectionIndex));
                this.textName.getTextControl().selectAll();
            }
        });
        this.textName = new LabeledText(dialogArea, 0);
        this.textName.setLabel(this.i18n.tr("Name"));
        this.textName.getTextControl().setTextLimit(63);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.textName.setLayoutData((Object)gd);
        this.textName.getTextControl().addModifyListener((ModifyListener & Serializable)listener -> {
            Button button;
            String name = this.textName.getText();
            int selectionIndex = this.comboDriverName.getSelectionIndex();
            if (selectionIndex != -1) {
                String driver = this.comboDriverName.getItem(selectionIndex);
                boolean bl = this.customName = !name.equals(driver);
            }
            if ((button = this.getButton(0)) != null) {
                button.setEnabled(!name.trim().isBlank());
            }
        });
        this.textDescription = new LabeledText(dialogArea, 0);
        this.textDescription.setLabel(this.i18n.tr("Description"));
        this.textDescription.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textDescription.setLayoutData((Object)gd);
        this.textConfiguraiton = new LabeledText(dialogArea, 0, 2050);
        this.textConfiguraiton.setLabel(this.i18n.tr("Driver configuration"));
        this.textConfiguraiton.getTextControl().setFont(JFaceResources.getTextFont());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 300;
        gd.widthHint = 900;
        this.textConfiguraiton.setLayoutData((Object)gd);
        if (this.nc != null) {
            this.textName.setText(this.nc.getName());
            this.textDescription.setText(this.nc.getDescription());
            this.textConfiguraiton.setText(this.nc.getConfiguration());
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return dialogArea;
    }

    private void updateUI(List<String> ncList) {
        int index = 0;
        if (!ncList.isEmpty()) {
            for (int i = 0; i < ncList.size(); ++i) {
                String item = ncList.get(i);
                this.comboDriverName.add(item);
                if (this.nc == null || !item.equals(this.nc.getDriverName())) continue;
                this.customName = !this.textName.getText().equals(this.nc.getDriverName());
                index = i;
            }
            this.comboDriverName.select(index);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.nc != null ? this.i18n.tr("Update notification channel") : this.i18n.tr("Create notification channel"));
    }

    protected void okPressed() {
        if (this.textName.getText().isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Notification channel name should not be empty"));
            return;
        }
        if (this.comboDriverName.getSelectionIndex() == -1) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Notification driver should be selected"));
            return;
        }
        if (this.nc == null) {
            this.nc = new NotificationChannel();
        }
        this.nc.setName(this.textName.getText());
        this.nc.setDescription(this.textDescription.getText());
        this.nc.setDriverName(this.comboDriverName.getItem(this.comboDriverName.getSelectionIndex()));
        this.nc.setConfiguration(this.textConfiguraiton.getText());
        super.okPressed();
    }

    public NotificationChannel getNotificaiotnChannel() {
        return this.nc;
    }
}

