/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.client.NXCSession;
import org.netxms.client.ScheduledTask;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;

public class ScheduledTaskFilter
extends ViewerFilter
implements AbstractViewerFilter {
    private NXCSession session = Registry.getSession();
    private String filterString = null;
    private boolean showSystemTasks = false;
    private boolean showDisabledTasks = true;
    private boolean showCompletedTasks = true;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        ScheduledTask task = (ScheduledTask)element;
        if (!this.showSystemTasks && task.isSystem()) {
            return false;
        }
        if (!this.showDisabledTasks && task.isDisabled()) {
            return false;
        }
        if (!this.showCompletedTasks && task.isCompleted() && !task.isRecurring()) {
            return false;
        }
        if (this.filterString != null && !this.filterString.isEmpty()) {
            return task.getComments().toLowerCase().contains(this.filterString) || task.getParameters().toLowerCase().contains(this.filterString) || task.getTaskHandlerId().toLowerCase().contains(this.filterString) || task.getObjectId() != 0L && this.session.getObjectName(task.getObjectId()).toLowerCase().contains(this.filterString);
        }
        return true;
    }

    public boolean isShowSystemTasks() {
        return this.showSystemTasks;
    }

    public void setShowSystemTasks(boolean showSystemTasks) {
        this.showSystemTasks = showSystemTasks;
    }

    public boolean isShowDisabledTasks() {
        return this.showDisabledTasks;
    }

    public void setShowDisabledTasks(boolean showDisabledTasks) {
        this.showDisabledTasks = showDisabledTasks;
    }

    public boolean isShowCompletedTasks() {
        return this.showCompletedTasks;
    }

    public void setShowCompletedTasks(boolean showCompletedTasks) {
        this.showCompletedTasks = showCompletedTasks;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }
}

