/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.users.dialogs;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class UIElementSelectionDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(UIElementSelectionDialog.class);
    private TableViewer viewer;
    private List<String> selection;

    public UIElementSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.i18n.tr("Select UI Element"));
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.viewer = new TableViewer(dialogArea, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 300;
        gd.widthHint = 600;
        this.viewer.getControl().setLayoutData((Object)gd);
        HashSet<CallSite> elements = new HashSet<CallSite>();
        for (Perspective p : Registry.getPerspectives()) {
            elements.add((CallSite)((Object)("perspective:" + p.getId())));
            for (String v : p.getRegsiteredViewIdentifiers()) {
                elements.add((CallSite)((Object)("view:" + v)));
            }
        }
        this.viewer.setInput(elements.toArray(String[]::new));
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("You must select at least one element from the list and then press OK."));
            return;
        }
        this.selection = new ArrayList(selection.size());
        for (Object e : selection.toList()) {
            this.selection.add((String)e);
        }
        super.okPressed();
    }

    public List<String> getSelection() {
        return this.selection;
    }

    static /* synthetic */ Button access$000(UIElementSelectionDialog x0, int x1) {
        return x0.getButton(x1);
    }
}

