/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base;

import java.util.HashMap;
import java.util.Map;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.base.UIElementFilter;

public class UIElementFilter {
    private boolean includeAll = false;
    private Map<ElementType, Filter> filters = new HashMap();

    public UIElementFilter(NXCSession session) {
        String rules = session.getUIAccessRules();
        if (rules == null || rules.isBlank()) {
            return;
        }
        for (String r : rules.toLowerCase().split(";")) {
            boolean isPattern;
            int set;
            if ((r = r.trim()).isEmpty()) continue;
            if (r.equals("*") || r.equals("*:*")) {
                this.includeAll = true;
            }
            if (r.charAt(0) == '!') {
                set = 2;
                r = r.substring(1);
            } else if (r.charAt(0) == '^') {
                set = 1;
                r = r.substring(1);
            } else {
                if (this.includeAll) continue;
                set = 0;
            }
            String[] parts = r.split(":", 2);
            if (parts.length != 2 || parts[0].isBlank() || parts[1].isBlank()) continue;
            ElementType type = switch (parts[0].toLowerCase()) {
                case "p", "perspective" -> ElementType.PERSPECTIVE;
                case "v", "view" -> ElementType.VIEW;
                case "*" -> ElementType.ANY;
                default -> null;
            };
            if (type == null) continue;
            Filter f = (Filter)this.filters.get(type);
            if (f == null) {
                f = new Filter();
                this.filters.put(type, f);
            }
            boolean bl = isPattern = parts[1].contains("*") || parts[1].contains("?");
            if (set == 2) {
                if (isPattern) {
                    f.exclusionPatterns.add(parts[1]);
                    continue;
                }
                f.exclusions.add(parts[1]);
                continue;
            }
            if (set == 1) {
                if (isPattern) {
                    f.priorityInclusionPatterns.add(parts[1]);
                    continue;
                }
                f.priorityInclusions.add(parts[1]);
                continue;
            }
            if (isPattern) {
                f.inclusionPatterns.add(parts[1]);
                continue;
            }
            f.inclusions.add(parts[1]);
        }
    }

    public boolean isVisible(ElementType type, String id) {
        Filter fa;
        id = id.trim().toLowerCase();
        Filter ft = (Filter)this.filters.get(type);
        if (ft != null) {
            if (ft.matchPriorityInclusions(id)) {
                return true;
            }
            if (ft.matchExclusions(id)) {
                return false;
            }
        }
        if ((fa = (Filter)this.filters.get(ElementType.ANY)) != null) {
            if (fa.matchPriorityInclusions(id)) {
                return true;
            }
            if (fa.matchExclusions(id)) {
                return false;
            }
        }
        if (this.includeAll) {
            return true;
        }
        if (ft != null && ft.matchInclusions(id)) {
            return true;
        }
        return fa != null && fa.matchInclusions(id);
    }
}

