/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.actions;

import java.util.List;
import org.eclipse.jface.viewers.ColumnViewer;
import org.netxms.nxmc.base.actions.TableRowAction;
import org.netxms.nxmc.base.actions.ViewerProvider;
import org.netxms.nxmc.tools.WidgetHelper;

public class CopyTableCellsAction
extends TableRowAction {
    private int column;

    public CopyTableCellsAction(ColumnViewer viewer, ViewerProvider viewerProvider, int column, boolean selectionOnly, String name) {
        super(viewer, viewerProvider, selectionOnly, name);
        this.column = column;
    }

    public CopyTableCellsAction(ColumnViewer viewer, int column, boolean selectionOnly, String name) {
        this(viewer, null, column, selectionOnly, name);
    }

    public CopyTableCellsAction(ViewerProvider viewerProvider, int column, boolean selectionOnly, String name) {
        this(null, viewerProvider, column, selectionOnly, name);
    }

    public void run() {
        List data = this.getRowsFromViewer(false);
        if (data.size() == 0) {
            WidgetHelper.copyToClipboard((String)"");
        } else if (data.size() == 1) {
            String[] row = (String[])data.get(0);
            WidgetHelper.copyToClipboard((String)(row.length > this.column ? row[this.column] : ""));
        } else {
            String nl = System.lineSeparator();
            StringBuilder sb = new StringBuilder();
            for (String[] row : data) {
                sb.append(row.length > this.column ? row[this.column] : "");
                sb.append(nl);
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }
}

