/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.actions;

import java.util.List;
import org.eclipse.jface.viewers.ColumnViewer;
import org.netxms.nxmc.base.actions.TableRowAction;
import org.netxms.nxmc.base.actions.ViewerProvider;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.WidgetHelper;

public class CopyTableRowsAction
extends TableRowAction {
    public CopyTableRowsAction(ColumnViewer viewer, ViewerProvider viewerProvider, boolean selectionOnly) {
        super(viewer, viewerProvider, selectionOnly, selectionOnly ? LocalizationHelper.getI18n(CopyTableRowsAction.class).tr("&Copy to clipboard") : LocalizationHelper.getI18n(CopyTableRowsAction.class).tr("&Copy all to clipboard"));
    }

    public CopyTableRowsAction(ColumnViewer viewer, boolean selectionOnly) {
        this(viewer, null, selectionOnly);
    }

    public CopyTableRowsAction(ViewerProvider viewerProvider, boolean selectionOnly) {
        this(null, viewerProvider, selectionOnly);
    }

    public void run() {
        List data = this.getRowsFromViewer(false);
        String nl = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        for (String[] row : data) {
            sb.append(row[0]);
            for (int i = 1; i < row.length; ++i) {
                sb.append('\t');
                sb.append(row[i]);
            }
            sb.append(nl);
        }
        WidgetHelper.copyToClipboard((String)sb.toString());
    }
}

