/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.base.dialogs.KeyValuePairEditDialog;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.base.widgets.helpers.KeyValuePairLabelProvider;
import org.netxms.nxmc.tools.ElementLabelComparator;

public class KeyValueSetEditor
extends Composite {
    private SortableTableViewer viewer;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonRemove;
    private String keyLabel;
    private String valueLabel;
    private Map<String, String> content = new HashMap();

    public KeyValueSetEditor(Composite parent, int style, String keyLabel, String valueLabel) {
        super(parent, style);
        this.keyLabel = keyLabel;
        this.valueLabel = valueLabel;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        String[] setColumnNames = new String[]{keyLabel, valueLabel};
        int[] setColumnWidths = new int[]{150, 300};
        this.viewer = new SortableTableViewer((Composite)this, setColumnNames, setColumnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new KeyValuePairLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)this.viewer.getLabelProvider()));
        this.viewer.setInput((Object)this.content.entrySet().toArray());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.viewer.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite((Composite)this, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        this.buttonAdd = new Button(buttons, 8);
        this.buttonAdd.setText("&Add...");
        this.buttonAdd.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        RowData rd = new RowData();
        rd.width = 90;
        this.buttonAdd.setLayoutData((Object)rd);
        this.buttonEdit = new Button(buttons, 8);
        this.buttonEdit.setText("&Edit...");
        this.buttonEdit.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.buttonEdit.setLayoutData((Object)rd);
        this.buttonEdit.setEnabled(false);
        this.buttonRemove = new Button(buttons, 8);
        this.buttonRemove.setText("&Delete");
        this.buttonRemove.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.buttonRemove.setLayoutData((Object)rd);
        this.buttonRemove.setEnabled(false);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.viewer.getControl().setLayoutData((Object)gd);
    }

    private void addEntry() {
        KeyValuePairEditDialog dlg = new KeyValuePairEditDialog(this.getShell(), null, null, true, true, this.keyLabel, this.valueLabel);
        if (dlg.open() == 0) {
            this.content.put(dlg.getKey(), dlg.getValue());
            this.viewer.setInput((Object)this.content.entrySet().toArray());
        }
    }

    private void editEntry() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        Map.Entry attr = (Map.Entry)selection.getFirstElement();
        KeyValuePairEditDialog dlg = new KeyValuePairEditDialog(this.getShell(), (String)attr.getKey(), (String)attr.getValue(), true, false, this.keyLabel, this.valueLabel);
        if (dlg.open() == 0) {
            this.content.put(dlg.getKey(), dlg.getValue());
            this.viewer.setInput((Object)this.content.entrySet().toArray());
        }
    }

    private void deleteEntry() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        Iterator it = selection.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                this.content.remove(e.getKey());
            }
            this.viewer.setInput((Object)this.content.entrySet().toArray());
        }
    }

    public void addAll(Map<String, String> entries) {
        this.content.putAll(entries);
        this.viewer.setInput((Object)entries.entrySet().toArray());
    }

    public void setContent(Map<String, String> entries) {
        this.content = entries;
    }

    public Map<String, String> getContent() {
        return this.content;
    }
}

