/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.ai.views;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.ai.AiAgentTask;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.ai.dialogs.AiTaskEditDialog;
import org.netxms.nxmc.modules.ai.views.helpers.AiTaskComparator;
import org.netxms.nxmc.modules.ai.views.helpers.AiTaskFilter;
import org.netxms.nxmc.modules.ai.views.helpers.AiTaskLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class AiTaskManager
extends ConfigurationView {
    private final I18n i18n = LocalizationHelper.getI18n(AiTaskManager.class);
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_DESCRIPTION = 1;
    public static final int COLUMN_OWNER = 2;
    public static final int COLUMN_STATE = 3;
    public static final int COLUMN_LAST_EXECUTION = 4;
    public static final int COLUMN_NEXT_EXECUTION = 5;
    public static final int COLUMN_EXPLANATION = 6;
    private SortableTableViewer viewer;
    private NXCSession session;
    private SessionListener sessionListener;
    private Map<Long, AiAgentTask> tasks = new HashMap();
    private Action actionNew;
    private Action actionDelete;

    public AiTaskManager() {
        super(LocalizationHelper.getI18n(AiTaskManager.class).tr("AI Tasks"), ResourceManager.getImageDescriptor((String)"icons/config-views/ai-tasks.png"), "configuration.ai-tasks", true);
        this.session = Registry.getSession();
    }

    protected void createContent(Composite parent) {
        String[] columnNames = new String[]{this.i18n.tr("ID"), this.i18n.tr("Description"), this.i18n.tr("Owner"), this.i18n.tr("State"), this.i18n.tr("Last Execution"), this.i18n.tr("Next Execution"), this.i18n.tr("Explanation")};
        int[] columnWidths = new int[]{90, 300, 150, 100, 150, 150, 400};
        this.viewer = new SortableTableViewer(parent, columnNames, columnWidths, 0, 128, 65538);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"AITaskManager");
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        AiTaskLabelProvider labelProvider = new AiTaskLabelProvider((TableViewer)this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setComparator((ViewerComparator)new AiTaskComparator());
        AiTaskFilter filter = new AiTaskFilter(labelProvider);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        this.viewer.addFilter((ViewerFilter)filter);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.sessionListener);
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.refresh();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }

    public void dispose() {
        this.session.removeListener(this.sessionListener);
        super.dispose();
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createActions() {
        this.actionNew = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+N", (IAction)this.actionNew);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+D", (IAction)this.actionDelete);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener & Serializable)m -> this.fillContextMenu(m));
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionDelete);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNew);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
    }

    private void createTask() {
        AiTaskEditDialog dlg = new AiTaskEditDialog(this.getWindow().getShell());
        if (dlg.open() != 0) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deleteTasks() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openConfirm((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Confirm Delete"), (String)this.i18n.tr("Do you really want to delete selected tasks?"))) {
            return;
        }
        Object[] objects = selection.toArray();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void updateTaskList() {
        this.viewer.getControl().getDisplay().asyncExec(() -> {
            Map map = this.tasks;
            synchronized (map) {
                this.viewer.setInput((Object)this.tasks.values().toArray());
            }
        });
    }
}

