/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.assetmanagement.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.asset.AssetAttribute;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Asset;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.assetmanagement.dialogs.EditAssetPropertyDialog;
import org.netxms.nxmc.modules.assetmanagement.views.AssetView;
import org.netxms.nxmc.modules.assetmanagement.views.helpers.AssetPropertyComparator;
import org.netxms.nxmc.modules.assetmanagement.views.helpers.AssetPropertyFilter;
import org.netxms.nxmc.modules.assetmanagement.views.helpers.AssetPropertyListLabelProvider;
import org.netxms.nxmc.modules.assetmanagement.views.helpers.AssetPropertyReader;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class AssetView
extends ObjectView {
    private final I18n i18n = LocalizationHelper.getI18n(AssetView.class);
    public static final int NAME = 0;
    public static final int VALUE = 1;
    public static final int IS_MANDATORY = 2;
    public static final int IS_UNIQUE = 3;
    public static final int SYSTEM_TYPE = 4;
    private SortableTableViewer viewer;
    private AssetPropertyFilter filter;
    private Map<String, String> properties;
    private AssetPropertyReader propertyReader;
    private MenuManager attributeSelectionSubMenu;
    private MenuManager attributeSelectionPopupMenu;
    private Action actionAdd;
    private Action actionEdit;
    private Action actionDelete;

    public AssetView() {
        super(LocalizationHelper.getI18n(AssetView.class).tr("Asset"), ResourceManager.getImageDescriptor((String)"icons/object-views/asset.png"), "objects.asset", true);
    }

    public boolean isValidForContext(Object context) {
        return context != null && (context instanceof Asset || ((AbstractObject)context).getAssetId() != 0L);
    }

    public int getPriority() {
        return 70;
    }

    protected void createContent(Composite parent) {
        this.propertyReader = new AssetPropertyReader();
        int[] widths = new int[]{200, 400, 100, 100, 200};
        String[] names = new String[]{this.i18n.tr("Property"), this.i18n.tr("Value"), this.i18n.tr("Mandatory"), this.i18n.tr("Unique"), this.i18n.tr("System type")};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AssetPropertyListLabelProvider(this.propertyReader));
        this.viewer.setComparator((ViewerComparator)new AssetPropertyComparator(this.propertyReader));
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.filter = new AssetPropertyFilter(this.propertyReader);
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"Asset");
        this.viewer.getControl().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
        this.refresh();
    }

    private void checkMandatoryAttributes() {
        if (this.getObject() == null) {
            return;
        }
        StringBuilder missingEntries = new StringBuilder();
        for (AssetAttribute definition : this.session.getAssetManagementSchema().values()) {
            if (!definition.isMandatory() || this.properties.containsKey(definition.getName())) continue;
            if (missingEntries.length() != 0) {
                missingEntries.append(", ");
            }
            missingEntries.append(this.propertyReader.getDisplayName(definition.getName()));
        }
        this.clearMessages();
        if (missingEntries.length() != 0) {
            this.addMessage(2, this.i18n.tr("The following mandatory properties are not set: {0}", (Object)missingEntries.toString()));
        }
    }

    void createActions() {
        3 menuListener = new /* Unavailable Anonymous Inner Class!! */;
        this.attributeSelectionSubMenu = new MenuManager(this.i18n.tr("&Add"));
        this.attributeSelectionSubMenu.setImageDescriptor(SharedIcons.ADD_OBJECT);
        this.attributeSelectionSubMenu.setRemoveAllWhenShown(true);
        this.attributeSelectionSubMenu.addMenuListener((IMenuListener)menuListener);
        this.attributeSelectionPopupMenu = new MenuManager(this.i18n.tr("Add"));
        this.attributeSelectionPopupMenu.setRemoveAllWhenShown(true);
        this.attributeSelectionPopupMenu.addMenuListener((IMenuListener)menuListener);
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
    }

    public void refresh() {
        Asset asset = null;
        AbstractObject object = this.getObject();
        if (object != null) {
            if (object instanceof Asset) {
                asset = (Asset)object;
            } else {
                long assetId = object.getAssetId();
                if (assetId != 0L) {
                    asset = (Asset)this.session.findObjectById(assetId, Asset.class);
                }
            }
        }
        this.properties = asset != null ? new HashMap(asset.getProperties()) : new HashMap(0);
        this.viewer.setInput((Object)this.properties.entrySet().toArray());
        this.checkMandatoryAttributes();
        if (this.actionAdd != null) {
            this.actionAdd.setEnabled(this.properties.size() < this.session.getAssetManagementSchemaSize());
        }
    }

    private void addProperty(String name) {
        EditAssetPropertyDialog dlg = new EditAssetPropertyDialog(this.getWindow().getShell(), name, null);
        if (dlg.open() != 0) {
            return;
        }
        String value = dlg.getValue();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void updateAttribute() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        Map.Entry element = (Map.Entry)selection.getFirstElement();
        String name = (String)element.getKey();
        EditAssetPropertyDialog dlg = new EditAssetPropertyDialog(this.getWindow().getShell(), name, (String)element.getValue());
        if (dlg.open() != 0) {
            return;
        }
        String value = dlg.getValue();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deleteAttribute() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Delete Property"), (String)this.i18n.tr("Selected properties will be deleted. Are you sure?"))) {
            return;
        }
        ArrayList<String> attributes = new ArrayList<String>(selection.size());
        for (Object o : selection.toList()) {
            attributes.add((String)((Map.Entry)o).getKey());
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void onObjectUpdate(AbstractObject object) {
        super.onObjectUpdate(object);
        this.refresh();
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        this.attributeSelectionPopupMenu.update(true);
        this.actionAdd = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAdd.setId("nxmc.add_asset_property");
        manager.add((IAction)this.actionAdd);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        this.attributeSelectionSubMenu.update(true);
        manager.add((IContributionItem)this.attributeSelectionSubMenu);
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = manager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        if (this.properties.size() < this.session.getAssetManagementSchemaSize()) {
            this.attributeSelectionSubMenu.update(true);
            mgr.add((IContributionItem)this.attributeSelectionSubMenu);
        }
        mgr.add((IAction)this.actionEdit);
        mgr.add((IAction)this.actionDelete);
    }

    protected boolean isRelatedObject(long objectId) {
        return objectId == this.getAssetId();
    }

    protected void onObjectChange(AbstractObject object) {
        this.refresh();
    }

    public void dispose() {
        this.propertyReader.dispose();
        super.dispose();
    }

    private long getAssetId() {
        AbstractObject object = this.getObject();
        if (object == null) {
            return 0L;
        }
        if (object instanceof Asset) {
            return object.getObjectId();
        }
        return object.getAssetId();
    }

    static /* synthetic */ NXCSession access$000(AssetView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$100(AssetView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$200(AssetView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$300(AssetView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$400(AssetView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$500(AssetView x0) {
        return x0.session;
    }
}

