/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.dialogs.helpers.BulkDciUpdateElementUI;
import org.netxms.nxmc.modules.datacollection.dialogs.helpers.BulkUpdateLabelProvider;
import org.netxms.nxmc.modules.datacollection.dialogs.helpers.BulkValueEditSupport;
import org.netxms.nxmc.modules.datacollection.propertypages.General;
import org.xnap.commons.i18n.I18n;

public class BulkUpdateDialog
extends Dialog {
    private TableViewer tableViewer;
    private List<BulkDciUpdateElementUI> elements;
    private I18n i18n = LocalizationHelper.getI18n(BulkUpdateDialog.class);

    public BulkUpdateDialog(Shell parentShell, boolean isCustomRetention, boolean isCustomInterval) {
        super(parentShell);
        this.elements = new ArrayList();
        String[] pollingModes = new String[]{this.i18n.tr("No change"), this.i18n.tr("Fixed intervals (default)"), this.i18n.tr("Fixed intervals (custom)"), this.i18n.tr("Custom schedule")};
        BulkDciUpdateElementUI pollingMode = new BulkDciUpdateElementUI(this.i18n.tr("Polling mode"), 666L, pollingModes);
        this.elements.add(pollingMode);
        this.elements.add(new BulkDciUpdateElementUI(this.i18n.tr("Polling interval (seconds)"), 44L, null, (BulkDciUpdateElementUI.EditModeSelector)new /* Unavailable Anonymous Inner Class!! */));
        String[] retentionTypes = new String[]{this.i18n.tr("No change"), this.i18n.tr("Use default retention time"), this.i18n.tr("Use custom retention time"), this.i18n.tr("Do not save collected data to database")};
        BulkDciUpdateElementUI retentionType = new BulkDciUpdateElementUI("Retention mode", 667L, retentionTypes);
        this.elements.add(retentionType);
        this.elements.add(new BulkDciUpdateElementUI(this.i18n.tr("Retention time (days)"), 45L, null, (BulkDciUpdateElementUI.EditModeSelector)new /* Unavailable Anonymous Inner Class!! */));
        ArrayList<String> dataUnits = new ArrayList<String>();
        dataUnits.add("No change");
        Collections.addAll(dataUnits, General.DATA_UNITS);
        BulkDciUpdateElementUI unitName = new BulkDciUpdateElementUI("Unit name", 324L, dataUnits.toArray(new String[dataUnits.size()]));
        unitName.setEditableDropdown(true);
        this.elements.add(unitName);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        int style = 35584;
        String[] columnNames = new String[]{this.i18n.tr("Attribute"), this.i18n.tr("Value")};
        this.tableViewer = new TableViewer(parent, style);
        this.tableViewer.setColumnProperties(columnNames);
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, 16384);
        column.getColumn().setText(this.i18n.tr("Attribute"));
        column.getColumn().setWidth(300);
        column = new TableViewerColumn(this.tableViewer, 16384);
        column.getColumn().setText(this.i18n.tr("Value"));
        column.getColumn().setWidth(400);
        column.setEditingSupport((EditingSupport)new BulkValueEditSupport(this.tableViewer));
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new BulkUpdateLabelProvider());
        this.tableViewer.setInput((Object)this.elements.toArray());
        return dialogArea;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Bulk DCI update");
    }

    protected void okPressed() {
        super.okPressed();
    }

    public List<BulkDciUpdateElementUI> getBulkUpdateElements() {
        return this.elements;
    }
}

