/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.ClusterResource;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.DataCollectionObjectEditor;
import org.netxms.nxmc.modules.datacollection.propertypages.AbstractDCIPropertyPage;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ClusterOptions
extends AbstractDCIPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(ClusterOptions.class);
    private AbstractObject owner;
    private Cluster cluster = null;
    private Combo clusterResource;
    private Map<Integer, Long> clusterResourceMap;
    private Button checkAggregate;
    private Button checkAggregateWithErrors;
    private Button checkRunScript;
    private Combo aggregationFunction;

    public ClusterOptions(DataCollectionObjectEditor editor) {
        super(LocalizationHelper.getI18n(ClusterOptions.class).tr("Cluster Options"), editor);
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        NXCSession session = Registry.getSession();
        this.owner = session.findObjectById(this.editor.getObject().getNodeId());
        if (this.owner instanceof Cluster) {
            this.cluster = (Cluster)this.owner;
        } else if (this.owner instanceof AbstractNode) {
            for (AbstractObject o : this.owner.getParentsAsArray()) {
                if (!(o instanceof Cluster)) continue;
                this.cluster = (Cluster)o;
                break;
            }
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.clusterResource = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)this.i18n.tr("Associate with cluster resource"), (Object)"WidgetHelper::default_layout_data");
        if (this.cluster != null) {
            this.clusterResourceMap = new HashMap();
            this.clusterResourceMap.put(0, 0L);
            this.clusterResource.add(this.i18n.tr("<none>"));
            if (this.editor.getObject().getResourceId() == 0L) {
                this.clusterResource.select(0);
            }
            int index = 1;
            for (ClusterResource r : this.cluster.getResources()) {
                this.clusterResource.add(r.getName());
                this.clusterResourceMap.put(index, r.getId());
                if (this.editor.getObject().getResourceId() == r.getId()) {
                    this.clusterResource.select(index);
                }
                ++index;
            }
        } else {
            this.clusterResource.add(this.i18n.tr("<none>"));
            this.clusterResource.select(0);
            this.clusterResource.setEnabled(false);
        }
        Group aggregationGroup = new Group(dialogArea, 0);
        aggregationGroup.setText(this.i18n.tr("Data aggregation"));
        aggregationGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        aggregationGroup.setLayout((Layout)layout);
        this.checkAggregate = new Button((Composite)aggregationGroup, 32);
        this.checkAggregate.setText(this.i18n.tr("Aggregate values from cluster nodes"));
        this.checkAggregate.setSelection(this.editor.getObject().isAggregateOnCluster());
        this.checkAggregateWithErrors = new Button((Composite)aggregationGroup, 32);
        this.checkAggregateWithErrors.setText("Use last known value for aggregation in case of data collection error");
        this.checkAggregateWithErrors.setSelection(this.editor.getObject().isAggregateWithErrors());
        this.checkRunScript = new Button((Composite)aggregationGroup, 32);
        this.checkRunScript.setText(this.i18n.tr("Run transformation script on aggregated data"));
        this.checkRunScript.setSelection(this.editor.getObject().isTransformAggregated());
        if (this.editor.getObject() instanceof DataCollectionItem) {
            this.checkAggregate.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.aggregationFunction = WidgetHelper.createLabeledCombo((Composite)aggregationGroup, (int)2056, (String)this.i18n.tr("Aggregation function"), (Object)"WidgetHelper::default_layout_data");
            this.aggregationFunction.add(this.i18n.tr("Total"));
            this.aggregationFunction.add(this.i18n.tr("Average"));
            this.aggregationFunction.add(this.i18n.tr("Min"));
            this.aggregationFunction.add(this.i18n.tr("Max"));
            this.aggregationFunction.select(this.editor.getObjectAsItem().getAggregationFunction());
            this.aggregationFunction.setEnabled(this.editor.getObjectAsItem().isAggregateOnCluster());
        }
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        if (this.cluster != null) {
            this.editor.getObject().setResourceId(((Long)this.clusterResourceMap.get(this.clusterResource.getSelectionIndex())).longValue());
        }
        this.editor.getObject().setAggregateOnCluster(this.checkAggregate.getSelection());
        this.editor.getObject().setAggregateWithErrors(this.checkAggregateWithErrors.getSelection());
        this.editor.getObject().setTransformAggregated(this.checkRunScript.getSelection());
        if (this.editor.getObject() instanceof DataCollectionItem) {
            this.editor.getObjectAsItem().setAggregationFunction(this.aggregationFunction.getSelectionIndex());
        }
        this.editor.modify();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.clusterResource.select(0);
        this.checkAggregate.setSelection(false);
        this.aggregationFunction.select(0);
        this.aggregationFunction.setEnabled(false);
    }
}

