/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.widgets.helpers;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.TableColumnDefinition;
import org.netxms.client.TableRow;
import org.netxms.client.datacollection.DataFormatter;
import org.netxms.nxmc.localization.DateFormatFactory;

public class TableLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableFontProvider {
    private TableColumnDefinition[] columns = null;
    private Font keyColumnFont;
    private boolean useMultipliers = true;

    public TableLabelProvider() {
        FontData fd = JFaceResources.getDefaultFont().getFontData()[0];
        fd.setStyle(1);
        this.keyColumnFont = new Font((Device)Display.getCurrent(), fd);
    }

    public void dispose() {
        this.keyColumnFont.dispose();
        super.dispose();
    }

    public void setColumns(TableColumnDefinition[] columns) {
        this.columns = columns;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        TableRow row = (TableRow)element;
        if (columnIndex >= row.size()) {
            return null;
        }
        return new DataFormatter().setDataType(this.columns[columnIndex].getDataType()).setMeasurementUnit(this.columns[columnIndex].getMeasurementUnit()).setMultiplierPower(this.columns[columnIndex].getMultiplierPower()).setUseMultipliers(this.columns[columnIndex].getUseMultiplier()).setDefaultForMultipliers(this.useMultipliers).format(row.get(columnIndex).getValue(), DateFormatFactory.getTimeFormatter());
    }

    public Font getFont(Object element, int columnIndex) {
        if (this.columns == null || columnIndex >= this.columns.length) {
            return null;
        }
        if (this.columns[columnIndex].isInstanceColumn()) {
            return this.keyColumnFont;
        }
        return null;
    }

    public void setUseMultipliers(boolean useMultipliers) {
        this.useMultipliers = useMultipliers;
    }

    public boolean areMultipliersUsed() {
        return this.useMultipliers;
    }
}

