/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.incidents.widgets;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.client.events.IncidentComment;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class IncidentCommentsEditor
extends Composite {
    private final I18n i18n = LocalizationHelper.getI18n(IncidentCommentsEditor.class);
    private NXCSession session = Registry.getSession();
    private Text text;

    public IncidentCommentsEditor(Composite parent, IncidentComment comment) {
        super(parent, 0);
        this.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        CLabel user = new CLabel((Composite)this, 0);
        AbstractUserObject userObject = this.session.findUserDBObjectById(comment.getUserId(), () -> parent.getDisplay().asyncExec(() -> {
            AbstractUserObject u;
            if (!user.isDisposed() && (u = this.session.findUserDBObjectById(comment.getUserId(), null)) != null) {
                user.setText(u.getName());
                user.getParent().layout(true, true);
            }
        }));
        user.setImage(SharedIcons.IMG_USER);
        user.setText(userObject != null ? userObject.getName() : this.i18n.tr("<unknown>"));
        user.setBackground(parent.getBackground());
        user.setForeground(WidgetHelper.getSystemColor((int)36));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        user.setLayoutData((Object)gd);
        Label time = new Label((Composite)this, 0);
        time.setText(DateFormatFactory.getDateTimeFormat().format(comment.getCreationTime()));
        time.setBackground(parent.getBackground());
        time.setForeground(WidgetHelper.getSystemColor((int)39));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        time.setLayoutData((Object)gd);
        this.text = new Text((Composite)this, 74);
        this.text.setText(comment.getText());
        this.text.setBackground(parent.getBackground());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.text.setLayoutData((Object)gd);
    }
}

