/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.elements;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.TimePeriod;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.InterfaceTrafficDcis;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.charts.api.ChartType;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.datacollection.views.HistoricalGraphView;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.elements.InterfaceTrafficChart;
import org.netxms.nxmc.modules.objects.views.elements.OverviewPageElement;
import org.netxms.nxmc.tools.ViewRefreshController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class InterfaceTrafficChart
extends OverviewPageElement
implements HistoricalGraphView.HistoricalChartOwner {
    private static Logger logger = LoggerFactory.getLogger(InterfaceTrafficChart.class);
    private final I18n i18n = LocalizationHelper.getI18n(InterfaceTrafficChart.class);
    private Chart chart;
    private InterfaceTrafficDcis items = null;
    ChartConfiguration chartConfiguration = new ChartConfiguration();
    private ViewRefreshController refreshController;
    private Composite content;
    private Composite labelControl;
    private Label label;
    private Action actionAdjustX;
    private Action actionAdjustY;
    private Action actionAdjustBoth;
    private Action[] presetActions;
    private boolean utilization;
    private int itemBase;

    public InterfaceTrafficChart(Composite parent, OverviewPageElement anchor, ObjectView objectView, boolean utilization) {
        super(parent, anchor, objectView);
        this.refreshController = new ViewRefreshController((View)objectView, -1, () -> this.refresh());
        this.utilization = utilization;
        this.itemBase = utilization ? 2 : 0;
        this.createActions();
    }

    protected String getTitle() {
        return this.utilization ? this.i18n.tr("Utilization") : this.i18n.tr("Traffic");
    }

    protected Control createClientArea(Composite parent) {
        this.content = new Composite(parent, 0);
        this.content.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        Date from = new Date(System.currentTimeMillis() - this.chartConfiguration.getTimeRangeMillis());
        Date to = new Date(System.currentTimeMillis());
        this.chartConfiguration.setZoomEnabled(false);
        this.chartConfiguration.setTitleVisible(false);
        this.chartConfiguration.setLegendVisible(true);
        this.chartConfiguration.setExtendedLegend(true);
        this.chartConfiguration.setUseMultipliers(true);
        this.chartConfiguration.setAutoScale(true);
        this.chartConfiguration.setTimePeriod(new TimePeriod());
        this.chart = new Chart(this.content, 0, ChartType.LINE, this.chartConfiguration, null);
        this.chart.setTimeRange(from, to);
        this.chart.addDoubleClickListener(e -> this.openHistoryGraph());
        this.chart.addDisposeListener((DisposeListener & Serializable)e -> this.refreshController.dispose());
        this.createChartContextMenu();
        this.labelControl = new Composite(this.content, 0);
        this.labelControl.setLayout((Layout)new GridLayout());
        this.label = new Label(this.labelControl, 0x1000000);
        this.label.setText("Loading...");
        GridData gd = new GridData(0x1000000, 0x1000000, true, true);
        this.label.setLayoutData((Object)gd);
        this.refreshController.setInterval(30);
        return this.content;
    }

    private void createActions() {
        this.actionAdjustX = HistoricalGraphView.createAction((HistoricalGraphView.ChartActionType)HistoricalGraphView.ChartActionType.ADJUST_X, (HistoricalGraphView.HistoricalChartOwner)this);
        this.actionAdjustY = HistoricalGraphView.createAction((HistoricalGraphView.ChartActionType)HistoricalGraphView.ChartActionType.ADJUST_Y, (HistoricalGraphView.HistoricalChartOwner)this);
        this.actionAdjustBoth = HistoricalGraphView.createAction((HistoricalGraphView.ChartActionType)HistoricalGraphView.ChartActionType.ADJUST_BOTH, (HistoricalGraphView.HistoricalChartOwner)this);
        this.presetActions = HistoricalGraphView.createPresetActions((HistoricalGraphView.PresetHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createChartContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener((IMenuListener & Serializable)m -> this.fillContextMenu(m));
        this.chart.setMenuManager(manager);
    }

    private void fillContextMenu(IMenuManager manager) {
        MenuManager presets = new MenuManager("&Presets");
        for (int i = 0; i < this.presetActions.length; ++i) {
            presets.add((IAction)this.presetActions[i]);
        }
        manager.add((IContributionItem)presets);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAdjustBoth);
        manager.add((IAction)this.actionAdjustX);
        manager.add((IAction)this.actionAdjustY);
    }

    protected int getHeightHint() {
        return 300;
    }

    private void openHistoryGraph() {
        ArrayList<ChartDciConfig> graphItems = new ArrayList<ChartDciConfig>(this.items.getDciList().length);
        for (int i = 0; i < this.chart.getItemCount(); ++i) {
            graphItems.add(new ChartDciConfig(this.chart.getItem(i)));
        }
        this.getObjectView().openView((View)new HistoricalGraphView(this.getObject(), graphItems, this.chart.getConfiguration(), 0L));
    }

    protected void onObjectChange() {
        this.items = null;
        this.chart.removeAllParameters();
        this.refresh();
    }

    private void refresh() {
        NXCSession session = Registry.getSession();
        long nodeId = ((Interface)this.getObject()).getParentNode().getObjectId();
        3 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }

    private void createChart(Long nodeId) {
        ChartDciConfig item;
        if (this.items.getDciList()[this.itemBase] == 0L && this.items.getDciList()[this.itemBase + 1] == 0L) {
            this.label.setText("No data");
            this.labelControl.moveAbove(null);
            return;
        }
        this.chart.moveAbove(null);
        if (this.items.getDciList()[this.itemBase] != 0L) {
            item = new ChartDciConfig();
            item.nodeId = nodeId;
            item.dciId = this.items.getDciList()[this.itemBase];
            item.name = "RX";
            item.lineChartType = -1;
            item.invertValues = false;
            item.showThresholds = true;
            this.chart.addParameter(item);
        }
        if (this.items.getDciList()[this.itemBase + 1] != 0L) {
            item = new ChartDciConfig();
            item.nodeId = nodeId;
            item.dciId = this.items.getDciList()[this.itemBase + 1];
            item.name = "TX";
            item.lineChartType = -1;
            item.invertValues = this.items.getDciList()[this.itemBase + 1] != 0L;
            item.showThresholds = true;
            this.chart.addParameter(item);
        }
        this.chart.rebuild();
    }

    public boolean isApplicableForObject(AbstractObject object) {
        return object instanceof Interface;
    }

    public Chart getChart() {
        return this.chart;
    }
}

