/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets.helpers;

import java.util.function.Consumer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.modules.objects.widgets.helpers.BaseObjectLabelProvider;
import org.netxms.nxmc.modules.objects.widgets.helpers.ObjectLabelDecorator;
import org.netxms.nxmc.resources.ThemeEngine;

public class DecoratingObjectLabelProvider
extends DecoratingLabelProvider {
    private Color maintenanceColor = ThemeEngine.getForegroundColor((String)"ObjectTree.Maintenance");
    private Color decommissionedColor = ThemeEngine.getForegroundColor((String)"ObjectTree.Decommissioned");

    public DecoratingObjectLabelProvider() {
        this(null, false);
    }

    public DecoratingObjectLabelProvider(Consumer<AbstractObject> imageUpdateCallback) {
        this(imageUpdateCallback, false);
    }

    public DecoratingObjectLabelProvider(boolean showFullPath) {
        this(null, showFullPath);
    }

    public DecoratingObjectLabelProvider(Consumer<AbstractObject> imageUpdateCallback, boolean showFullPath) {
        super((ILabelProvider)new BaseObjectLabelProvider(imageUpdateCallback, showFullPath), (ILabelDecorator)new ObjectLabelDecorator());
    }

    public void setShowChildCount(boolean show) {
        ((ObjectLabelDecorator)this.getLabelDecorator()).setShowChildCount(show);
    }

    public Color getForeground(Object element) {
        AbstractObject object = (AbstractObject)element;
        if (object.isInMaintenanceMode()) {
            return this.maintenanceColor;
        }
        if (object instanceof AbstractNode && ((AbstractNode)object).isDecommissioned()) {
            return this.decommissionedColor;
        }
        return null;
    }
}

