/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.worldmap.widgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.presentations.PresentationUtil;
import org.netxms.base.GeoLocation;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.widgets.helpers.DecoratingObjectLabelProvider;
import org.netxms.nxmc.modules.worldmap.GeoLocationCache;
import org.netxms.nxmc.modules.worldmap.GeoLocationCacheListener;
import org.netxms.nxmc.modules.worldmap.GeoMapListener;
import org.netxms.nxmc.modules.worldmap.tools.Area;
import org.netxms.nxmc.modules.worldmap.tools.MapAccessor;
import org.netxms.nxmc.modules.worldmap.tools.MapLoader;
import org.netxms.nxmc.modules.worldmap.tools.Tile;
import org.netxms.nxmc.modules.worldmap.tools.TileSet;
import org.netxms.nxmc.modules.worldmap.widgets.AbstractGeoMapViewer;
import org.netxms.nxmc.tools.ColorCache;
import org.netxms.nxmc.tools.FontTools;
import org.netxms.nxmc.tools.RAPDragTracker;
import org.xnap.commons.i18n.I18n;

public abstract class AbstractGeoMapViewer
extends Canvas
implements PaintListener,
GeoLocationCacheListener,
MouseListener,
MouseMoveListener {
    private final I18n i18n = LocalizationHelper.getI18n(AbstractGeoMapViewer.class);
    protected static final Color BORDER_COLOR = new Color((Device)Display.getCurrent(), 0, 0, 0);
    protected static final int LABEL_ARROW_HEIGHT = 20;
    protected static final int LABEL_X_MARGIN = 12;
    protected static final int LABEL_Y_MARGIN = 12;
    protected static final int LABEL_SPACING = 4;
    protected static final Color SELECTION_COLOR = new Color((Device)Display.getCurrent(), 0, 0, 255);
    private static final int DRAG_JITTER = 8;
    private static final int BUTTON_MARGIN_WIDTH = 10;
    private static final int BUTTON_MARGIN_HEIGHT = 5;
    private static final int BUTTON_BLOCK_MARGIN_WIDTH = 10;
    private static final int BUTTON_BLOCK_MARGIN_HEIGHT = 15;
    protected ColorCache colorCache;
    protected ILabelProvider labelProvider;
    protected Area coverage = new Area(0.0, 0.0, 0.0, 0.0);
    protected MapAccessor accessor = new MapAccessor(0.0, 0.0, 4);
    protected View view = null;
    protected Point currentPoint;
    private MapLoader mapLoader;
    private Point dragStartPoint = null;
    private Point selectionStartPoint = null;
    private Point selectionEndPoint = null;
    private Set<GeoMapListener> mapListeners = new HashSet(0);
    private String title = null;
    private int offsetX;
    private int offsetY;
    private int contentVerticalOffset = 0;
    private TileSet currentTileSet = null;
    private Rectangle zoomControlRect = null;
    private Rectangle titleRect = null;
    private Font controlFont;
    private boolean enableControls = true;
    private boolean fullVerticalCoverage = false;
    private RAPDragTracker tracker;

    public AbstractGeoMapViewer(Composite parent, int style, View view) {
        super(parent, style);
        this.view = view;
        this.colorCache = new ColorCache((Control)this);
        this.controlFont = FontTools.createAdjustedFont((Font)JFaceResources.getTextFont(), (int)12, (int)1);
        this.labelProvider = new DecoratingObjectLabelProvider();
        this.mapLoader = new MapLoader(this.getDisplay());
        this.setBackground(this.getDisplay().getSystemColor(22));
        this.addPaintListener((PaintListener)this);
        1 timer = new /* Unavailable Anonymous Inner Class!! */;
        this.addListener(11, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMouseListener((MouseListener)this);
        PresentationUtil.addDragListener((Control)this, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        DragSource dragSource = new DragSource((Control)this, 7);
        5 listener = new /* Unavailable Anonymous Inner Class!! */;
        dragSource.addDragListener((DragSourceListener)listener);
        GeoLocationCache.getInstance().addListener((GeoLocationCacheListener)this);
    }

    public void enableMapControls(boolean enable) {
        this.enableControls = enable;
        this.redraw();
    }

    public void addMapListener(GeoMapListener listener) {
        this.mapListeners.add(listener);
    }

    public void removeMapListener(GeoMapListener listener) {
        this.mapListeners.remove(listener);
    }

    private void notifyOnZoomChange() {
        for (GeoMapListener listener : this.mapListeners) {
            listener.onZoom(this.accessor.getZoom());
        }
    }

    private void notifyOnPositionChange() {
        for (GeoMapListener listener : this.mapListeners) {
            listener.onPan(this.accessor.getCenterPoint());
        }
    }

    public void showMap(MapAccessor accessor) {
        this.accessor = new MapAccessor(accessor);
        this.reloadMap();
    }

    public void showMap(double lat, double lon, int zoom) {
        this.showMap(new MapAccessor(lat, lon, zoom));
    }

    public void reloadMap() {
        Point size = this.getSize();
        Point virtualMapSize = GeoLocationCache.getVirtualMapSize((int)this.accessor.getZoom());
        if (virtualMapSize.y < size.y) {
            size.y = virtualMapSize.y;
        }
        this.accessor.setMapWidth(size.x);
        this.accessor.setMapHeight(size.y);
        if (!this.accessor.isValid()) {
            return;
        }
        Point mapSize = new Point(this.accessor.getMapWidth(), this.accessor.getMapHeight());
        GeoLocation centerPoint = this.accessor.getCenterPoint();
        6 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    protected abstract void onMapLoad();

    private void loadMissingTiles(TileSet tiles) {
        7 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void drawTiles(GC gc, TileSet tileSet) {
        Tile[][] tiles = tileSet.tiles;
        Point size = this.getSize();
        Point virtualMapSize = GeoLocationCache.getVirtualMapSize((int)this.accessor.getZoom());
        if (size.y > virtualMapSize.y) {
            this.contentVerticalOffset = (size.y - virtualMapSize.y) / 2;
            size.y = virtualMapSize.y;
        }
        int x = tileSet.xOffset;
        int y = tileSet.yOffset;
        for (int i = 0; i < tiles.length; ++i) {
            for (int j = 0; j < tiles[i].length; ++j) {
                if (!tiles[i][j].getImage().isDisposed()) {
                    gc.drawImage(tiles[i][j].getImage(), x, y + this.contentVerticalOffset);
                }
                if ((x += 256) < size.x) continue;
                x = tileSet.xOffset;
                y += 256;
            }
        }
    }

    public void paintControl(PaintEvent e) {
        Rectangle rect;
        GeoLocation currentLocation;
        GC gc = e.gc;
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        if (this.currentTileSet != null) {
            this.drawTiles(gc, this.currentTileSet);
        }
        if (this.dragStartPoint == null) {
            currentLocation = this.accessor.getCenterPoint();
            Rectangle rect2 = this.getClientArea();
            this.drawContent(gc, currentLocation, rect2.width, rect2.height, this.contentVerticalOffset);
        } else {
            Point cp = GeoLocationCache.coordinateToDisplay((GeoLocation)this.accessor.getCenterPoint(), (int)this.accessor.getZoom());
            cp.x += this.offsetX;
            cp.y += this.offsetY;
            currentLocation = GeoLocationCache.displayToCoordinates((Point)cp, (int)this.accessor.getZoom(), (boolean)true);
        }
        if (this.selectionStartPoint != null && this.selectionEndPoint != null) {
            int x = Math.min(this.selectionStartPoint.x, this.selectionEndPoint.x);
            int y = Math.min(this.selectionStartPoint.y, this.selectionEndPoint.y);
            int w = Math.abs(this.selectionStartPoint.x - this.selectionEndPoint.x);
            int h = Math.abs(this.selectionStartPoint.y - this.selectionEndPoint.y);
            gc.setBackground(SELECTION_COLOR);
            gc.setForeground(SELECTION_COLOR);
            gc.setAlpha(64);
            gc.fillRectangle(x, y, w, h);
            gc.setAlpha(255);
            gc.setLineWidth(2);
            gc.drawRectangle(x, y, w, h);
        }
        gc.setFont(null);
        String text = "Map data \u00a9 OpenStreetMap contributors\tZoom level " + this.accessor.getZoom() + "\tCentered at " + currentLocation.toString();
        Point infoTextSize = gc.textExtent(text);
        Rectangle infoTextRectangle = this.getClientArea();
        infoTextRectangle.x = infoTextRectangle.width - infoTextSize.x - 10;
        infoTextRectangle.y = infoTextRectangle.height - infoTextSize.y - 8;
        infoTextRectangle.width = infoTextSize.x + 11;
        infoTextRectangle.height = infoTextSize.y + 9;
        gc.setBackground(this.getDisplay().getSystemColor(22));
        gc.fillRectangle(infoTextRectangle.x, infoTextRectangle.y, infoTextRectangle.width, infoTextRectangle.height);
        gc.setForeground(this.getDisplay().getSystemColor(21));
        gc.drawText(text, infoTextRectangle.x + 5, infoTextRectangle.y + 4, true);
        if (this.title != null && !this.title.isEmpty()) {
            gc.setFont(JFaceResources.getBannerFont());
            Point size = gc.textExtent(this.title);
            rect = this.getClientArea();
            rect.x = rect.width / 2 - size.x / 2 - 8;
            rect.y = 10;
            rect.width = size.x + 16;
            rect.height = size.y + 10;
            gc.setBackground(this.getDisplay().getSystemColor(25));
            gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
            gc.setForeground(this.getDisplay().getSystemColor(23));
            gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
            gc.setForeground(this.getDisplay().getSystemColor(24));
            gc.drawText(this.title, rect.x + 8, rect.y + 6);
            this.titleRect = rect;
        } else {
            this.titleRect = null;
        }
        if (this.enableControls) {
            gc.setFont(this.controlFont);
            Point buttonSize = gc.textExtent("+");
            buttonSize.x += 20;
            buttonSize.y += 10;
            rect = this.getClientArea();
            rect.x = rect.width - buttonSize.x - 10;
            rect.y = rect.height - buttonSize.y * 2 - infoTextRectangle.height - 15;
            rect.width = buttonSize.x;
            rect.height = buttonSize.y * 2 + 1;
            gc.setBackground(this.getDisplay().getSystemColor(25));
            gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
            gc.setForeground(this.getDisplay().getSystemColor(23));
            gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
            gc.drawLine(rect.x, rect.y + buttonSize.y + 1, rect.x + rect.width, rect.y + buttonSize.y + 1);
            gc.setForeground(this.getDisplay().getSystemColor(24));
            gc.drawText("+", rect.x + 10, rect.y + 5, true);
            gc.drawText("-", rect.x + 10, rect.y + buttonSize.y + 5, true);
            this.zoomControlRect = rect;
        }
    }

    protected abstract void drawContent(GC var1, GeoLocation var2, int var3, int var4, int var5);

    public void geoLocationCacheChanged(AbstractObject object, GeoLocation prevLocation) {
        this.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected abstract void onCacheChange(AbstractObject var1, GeoLocation var2);

    public void mouseDoubleClick(MouseEvent e) {
        if (!this.enableControls || e.button != 1 || this.zoomControlRect.contains(e.x, e.y) || this.titleRect != null && this.titleRect.contains(e.x, e.y)) {
            return;
        }
        int zoom = this.accessor.getZoom();
        if (zoom < 19) {
            int step = (e.stateMask & 0x20000) != 0 ? 4 : 1;
            zoom = zoom + step > 19 ? 19 : zoom + step;
            GeoLocation geoLocation = this.getLocationAtPoint(new Point(e.x, e.y));
            this.accessor.setZoom(zoom);
            this.accessor.setLatitude(geoLocation.getLatitude());
            this.accessor.setLongitude(geoLocation.getLongitude());
            this.checkVerticalCoverage();
            this.reloadMap();
            this.notifyOnZoomChange();
            this.notifyOnPositionChange();
        }
    }

    public void mouseDown(MouseEvent e) {
        if (!this.enableControls) {
            return;
        }
        if (e.button == 1) {
            if (this.zoomControlRect.contains(e.x, e.y)) {
                Rectangle r = new Rectangle(this.zoomControlRect.x, this.zoomControlRect.y, this.zoomControlRect.width, this.zoomControlRect.height / 2);
                int zoom = this.accessor.getZoom();
                if (r.contains(e.x, e.y)) {
                    if (zoom < 19) {
                        ++zoom;
                    }
                } else {
                    r.y += this.zoomControlRect.height / 2 + 1;
                    if (r.contains(e.x, e.y) && zoom > 1) {
                        Point virtualMapSize = GeoLocationCache.getVirtualMapSize((int)zoom);
                        Point widgetSize = this.getSize();
                        if (widgetSize.x < virtualMapSize.x || widgetSize.y < virtualMapSize.y) {
                            --zoom;
                        }
                    }
                }
                if (zoom != this.accessor.getZoom()) {
                    this.accessor.setZoom(zoom);
                    this.checkVerticalCoverage();
                    this.reloadMap();
                    this.notifyOnZoomChange();
                }
            } else if (this.titleRect == null || !this.titleRect.contains(e.x, e.y)) {
                if ((e.stateMask & 0x20000) != 0) {
                    if (this.accessor.getZoom() < 19) {
                        this.selectionStartPoint = new Point(e.x, e.y);
                    }
                } else {
                    this.dragStartPoint = new Point(e.x, e.y);
                    this.setCursor(this.getDisplay().getSystemCursor(5));
                }
            }
        }
        this.currentPoint = new Point(e.x, e.y);
    }

    public void mouseUp(MouseEvent e) {
        if (e.button == 1 && this.dragStartPoint != null) {
            if (Math.abs(this.offsetX) > 8 || Math.abs(this.offsetY) > 8) {
                Point centerXY = GeoLocationCache.coordinateToDisplay((GeoLocation)this.accessor.getCenterPoint(), (int)this.accessor.getZoom());
                centerXY.x += this.offsetX;
                centerXY.y += this.offsetY;
                GeoLocation geoLocation = GeoLocationCache.displayToCoordinates((Point)centerXY, (int)this.accessor.getZoom(), (boolean)true);
                this.accessor.setLatitude(geoLocation.getLatitude());
                this.accessor.setLongitude(geoLocation.getLongitude());
                this.reloadMap();
                this.notifyOnPositionChange();
            }
            this.offsetX = 0;
            this.offsetY = 0;
            this.dragStartPoint = null;
            this.setCursor(null);
        }
        if (e.button == 1 && this.selectionStartPoint != null) {
            if (this.selectionEndPoint != null) {
                int x1 = Math.min(this.selectionStartPoint.x, this.selectionEndPoint.x);
                int x2 = Math.max(this.selectionStartPoint.x, this.selectionEndPoint.x);
                int y1 = Math.min(this.selectionStartPoint.y, this.selectionEndPoint.y);
                int y2 = Math.max(this.selectionStartPoint.y, this.selectionEndPoint.y);
                GeoLocation l1 = this.getLocationAtPoint(new Point(x1, y1));
                GeoLocation l2 = this.getLocationAtPoint(new Point(x2, y2));
                GeoLocation lc = this.getLocationAtPoint(new Point(x2 - (x2 - x1) / 2, y2 - (y2 - y1) / 2));
                int zoom = this.accessor.getZoom();
                while (zoom < 19) {
                    Area area = GeoLocationCache.calculateCoverage((Point)this.getSize(), (GeoLocation)lc, (int)0, (int)(++zoom));
                    if (area.contains(l1.getLatitude(), l1.getLongitude()) && area.contains(l2.getLatitude(), l2.getLongitude())) continue;
                    --zoom;
                    break;
                }
                if (zoom != this.accessor.getZoom()) {
                    this.accessor.setZoom(zoom);
                    this.accessor.setLatitude(lc.getLatitude());
                    this.accessor.setLongitude(lc.getLongitude());
                    this.checkVerticalCoverage();
                    this.reloadMap();
                    this.notifyOnPositionChange();
                    this.notifyOnZoomChange();
                }
            }
            this.selectionStartPoint = null;
            this.selectionEndPoint = null;
            this.redraw();
        }
    }

    public void mouseMove(MouseEvent e) {
        int deltaY;
        int deltaX;
        if (this.dragStartPoint != null) {
            deltaX = this.dragStartPoint.x - e.x;
            int n = deltaY = this.fullVerticalCoverage ? 0 : this.dragStartPoint.y - e.y;
            if (Math.abs(deltaX) > 8 || Math.abs(deltaY) > 8) {
                this.offsetX = deltaX;
                this.offsetY = deltaY;
                this.redraw();
            }
        }
        if (this.selectionStartPoint != null) {
            deltaX = this.selectionStartPoint.x - e.x;
            deltaY = this.selectionStartPoint.y - e.y;
            if (Math.abs(deltaX) > 8 || Math.abs(deltaY) > 8) {
                this.selectionEndPoint = new Point(e.x, e.y);
                this.redraw();
            }
        }
    }

    public Point getCurrentPoint() {
        return new Point(this.currentPoint.x, this.currentPoint.y);
    }

    public GeoLocation getLocationAtPoint(Point p) {
        Point cp = GeoLocationCache.coordinateToDisplay((GeoLocation)new GeoLocation(this.coverage.getxHigh(), this.coverage.getyLow()), (int)this.accessor.getZoom());
        return GeoLocationCache.displayToCoordinates((Point)new Point(cp.x + p.x, cp.y + p.y - this.contentVerticalOffset), (int)this.accessor.getZoom(), (boolean)true);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public abstract AbstractObject getObjectAtPoint(Point var1);

    private void checkVerticalCoverage() {
        Point size = this.getSize();
        Point virtualMapSize = GeoLocationCache.getVirtualMapSize((int)this.accessor.getZoom());
        if (size.y >= virtualMapSize.y) {
            this.fullVerticalCoverage = true;
            this.contentVerticalOffset = (size.y - virtualMapSize.y) / 2;
            this.accessor.setLatitude(0.0);
        } else {
            this.fullVerticalCoverage = false;
            this.contentVerticalOffset = 0;
        }
    }
}

