/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.util;

import org.codehaus.commons.nullanalysis.Nullable;

public final class SystemProperties {
    private SystemProperties() {
    }

    public static boolean getBooleanClassProperty(Class<?> targetClass, String classPropertyName) {
        return SystemProperties.getBooleanClassProperty(targetClass, classPropertyName, false);
    }

    public static boolean getBooleanClassProperty(Class<?> targetClass, String classPropertyName, boolean defaultValue) {
        String s = SystemProperties.getClassProperty(targetClass, classPropertyName);
        return s != null ? Boolean.parseBoolean(s) : defaultValue;
    }

    public static int getIntegerClassProperty(Class<?> targetClass, String classPropertyName, int defaultValue) {
        String s = SystemProperties.getClassProperty(targetClass, classPropertyName);
        return s != null ? Integer.parseInt(s) : defaultValue;
    }

    @Nullable
    public static String getClassProperty(Class<?> targetClass, String classPropertyName) {
        return SystemProperties.getClassProperty(targetClass, classPropertyName, null);
    }

    @Nullable
    public static String getClassProperty(Class<?> targetClass, String classPropertyName, @Nullable String defaultValue) {
        String result22;
        try {
            result22 = System.getProperty(targetClass.getName() + "." + classPropertyName);
            if (result22 != null) {
                return result22;
            }
        }
        catch (SecurityException result22) {
            // empty catch block
        }
        try {
            result22 = System.getProperty(targetClass.getSimpleName() + "." + classPropertyName);
            if (result22 != null) {
                return result22;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return defaultValue;
    }
}

