/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ColumnFilterType {
    EQUALS(0),
    RANGE(1),
    SET(2),
    LIKE(3),
    LESS(4),
    GREATER(5),
    CHILDOF(6),
    UNKNOWN(7);

    private static Logger logger;
    private static Map<Integer, ColumnFilterType> lookupTable;
    private int value;

    private ColumnFilterType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ColumnFilterType getByValue(int value) {
        ColumnFilterType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(ColumnFilterType.class);
        lookupTable = new HashMap<Integer, ColumnFilterType>();
        for (ColumnFilterType element : ColumnFilterType.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

