/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.datacollection.TableCondition;

public class TableThreshold {
    private static final String[] OPERATIONS = new String[]{"<", "<=", "==", ">=", ">", "!=", "LIKE", "NOT LIKE"};
    private long id;
    private int activationEvent;
    private int deactivationEvent;
    private int sampleCount;
    private List<List<TableCondition>> conditions;
    private long nextFieldId;

    public TableThreshold() {
        this.id = 0L;
        this.activationEvent = 69;
        this.deactivationEvent = 70;
        this.sampleCount = 1;
        this.conditions = new ArrayList<List<TableCondition>>(0);
    }

    public TableThreshold(TableThreshold src) {
        this.id = src.id;
        this.activationEvent = src.activationEvent;
        this.deactivationEvent = src.deactivationEvent;
        this.sampleCount = src.sampleCount;
        this.conditions = new ArrayList<List<TableCondition>>(src.conditions.size());
        for (List<TableCondition> sl : src.conditions) {
            ArrayList<TableCondition> dl = new ArrayList<TableCondition>(sl.size());
            for (TableCondition c : sl) {
                dl.add(new TableCondition(c));
            }
            this.conditions.add(dl);
        }
    }

    protected TableThreshold(NXCPMessage msg, long baseId) {
        long fieldId = baseId;
        this.id = msg.getFieldAsInt64(fieldId++);
        this.activationEvent = msg.getFieldAsInt32(fieldId++);
        this.deactivationEvent = msg.getFieldAsInt32(fieldId++);
        this.sampleCount = msg.getFieldAsInt32(fieldId++);
        int groupCount = msg.getFieldAsInt32(fieldId++);
        this.conditions = new ArrayList<List<TableCondition>>(groupCount);
        for (int i = 0; i < groupCount; ++i) {
            int condCount = msg.getFieldAsInt32(fieldId++);
            ArrayList<TableCondition> list = new ArrayList<TableCondition>(condCount);
            for (int j = 0; j < condCount; ++j) {
                list.add(new TableCondition(msg, fieldId));
                fieldId += 3L;
            }
            this.conditions.add(list);
        }
        this.nextFieldId = fieldId;
    }

    protected long fillMessage(NXCPMessage msg, long baseId) {
        long fieldId = baseId;
        msg.setFieldInt32(fieldId++, (int)this.id);
        msg.setFieldInt32(fieldId++, this.activationEvent);
        msg.setFieldInt32(fieldId++, this.deactivationEvent);
        msg.setFieldInt32(fieldId++, this.sampleCount);
        msg.setFieldInt32(fieldId++, this.conditions.size());
        for (List<TableCondition> l : this.conditions) {
            msg.setFieldInt32(fieldId++, l.size());
            for (TableCondition c : l) {
                msg.setField(fieldId++, c.getColumn());
                msg.setFieldInt16(fieldId++, c.getOperation());
                msg.setField(fieldId++, c.getValue());
            }
        }
        return fieldId;
    }

    public String getConditionAsText() {
        StringBuilder sb = new StringBuilder();
        for (List<TableCondition> group : this.conditions) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            if (this.conditions.size() > 1) {
                sb.append('(');
            }
            for (TableCondition cond : group) {
                if (cond != group.get(0)) {
                    sb.append(" AND ");
                }
                sb.append(cond.getColumn());
                sb.append(' ');
                try {
                    sb.append(OPERATIONS[cond.getOperation()]);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    sb.append('?');
                }
                sb.append(' ');
                sb.append(cond.getValue());
            }
            if (this.conditions.size() <= 1) continue;
            sb.append(')');
        }
        return sb.toString();
    }

    public long getNextFieldId() {
        return this.nextFieldId;
    }

    public int getActivationEvent() {
        return this.activationEvent;
    }

    public void setActivationEvent(int activationEvent) {
        this.activationEvent = activationEvent;
    }

    public int getDeactivationEvent() {
        return this.deactivationEvent;
    }

    public void setDeactivationEvent(int deactivationEvent) {
        this.deactivationEvent = deactivationEvent;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public void setSampleCount(int sampleCount) {
        this.sampleCount = sampleCount;
    }

    public List<List<TableCondition>> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<List<TableCondition>> conditions) {
        this.conditions = conditions;
    }

    public long getId() {
        return this.id;
    }

    public TableThreshold duplicate() {
        TableThreshold tr = new TableThreshold(this);
        tr.id = 0L;
        return tr;
    }
}

