/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AiMessageStatus {
    PENDING(0),
    READ(1),
    APPROVED(2),
    REJECTED(3),
    EXPIRED(4),
    UNKNOWN(-1);

    private static Logger logger;
    private static Map<Integer, AiMessageStatus> lookupTable;
    private int value;

    private AiMessageStatus(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AiMessageStatus getByValue(int value) {
        AiMessageStatus element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(AiMessageStatus.class);
        lookupTable = new HashMap<Integer, AiMessageStatus>();
        for (AiMessageStatus element : AiMessageStatus.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

