/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AiTaskState {
    SCHEDULED(0),
    RUNNING(1),
    COMPLETED(2),
    FAILED(3),
    UNKNOWN(-1);

    private static Logger logger;
    private static Map<Integer, AiTaskState> lookupTable;
    private int value;

    private AiTaskState(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AiTaskState getByValue(int value) {
        AiTaskState element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(AiTaskState.class);
        lookupTable = new HashMap<Integer, AiTaskState>();
        for (AiTaskState element : AiTaskState.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

