/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DataCollectionObjectStatus {
    ACTIVE(0),
    DISABLED(1),
    UNSUPPORTED(2);

    private static Logger logger;
    private static Map<Integer, DataCollectionObjectStatus> lookupTable;
    private int value;

    private DataCollectionObjectStatus(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static DataCollectionObjectStatus getByValue(int value) {
        DataCollectionObjectStatus element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return ACTIVE;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(DataCollectionObjectStatus.class);
        lookupTable = new HashMap<Integer, DataCollectionObjectStatus>();
        for (DataCollectionObjectStatus element : DataCollectionObjectStatus.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

