/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum IncidentState {
    OPEN(0),
    IN_PROGRESS(1),
    BLOCKED(2),
    RESOLVED(3),
    CLOSED(4);

    private static Logger logger;
    private static Map<Integer, IncidentState> lookupTable;
    private int value;

    private IncidentState(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static IncidentState getByValue(int value) {
        IncidentState element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return OPEN;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(IncidentState.class);
        lookupTable = new HashMap<Integer, IncidentState>();
        for (IncidentState element : IncidentState.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

