/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.reporting;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ReportRenderFormat {
    NONE(0, "none"),
    PDF(1, "pdf"),
    XLSX(2, "xlsx");

    private final int code;
    private final String extension;
    private static final Map<Integer, ReportRenderFormat> lookupTable;

    private ReportRenderFormat(int code2, String extenstion) {
        this.code = code2;
        this.extension = extenstion;
    }

    public int getCode() {
        return this.code;
    }

    public static final ReportRenderFormat valueOf(Integer code2) {
        return lookupTable.containsKey(code2) ? lookupTable.get(code2) : NONE;
    }

    public String getExtension() {
        return this.extension;
    }

    static {
        lookupTable = new HashMap<Integer, ReportRenderFormat>(2);
        for (ReportRenderFormat element : EnumSet.allOf(ReportRenderFormat.class)) {
            lookupTable.put(element.getCode(), element);
        }
    }
}

