/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.ai;

import java.util.Date;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.AiMessageStatus;
import org.netxms.client.constants.AiMessageType;

public class AiMessage {
    private long id;
    private UUID guid;
    private AiMessageType messageType;
    private Date creationTime;
    private Date expirationTime;
    private long sourceTaskId;
    private String sourceTaskType;
    private long relatedObjectId;
    private String title;
    private String text;
    private String spawnTaskData;
    private AiMessageStatus status;

    public AiMessage(NXCPMessage msg, long baseId) {
        this.id = msg.getFieldAsInt64(baseId);
        this.guid = msg.getFieldAsUUID(baseId + 1L);
        this.messageType = AiMessageType.getByValue(msg.getFieldAsInt32(baseId + 2L));
        this.creationTime = msg.getFieldAsDate(baseId + 3L);
        this.expirationTime = msg.getFieldAsDate(baseId + 4L);
        this.sourceTaskId = msg.getFieldAsInt64(baseId + 5L);
        this.sourceTaskType = msg.getFieldAsString(baseId + 6L);
        this.relatedObjectId = msg.getFieldAsInt64(baseId + 7L);
        this.title = msg.getFieldAsString(baseId + 8L);
        this.text = msg.getFieldAsString(baseId + 9L);
        this.spawnTaskData = msg.getFieldAsString(baseId + 10L);
        this.status = AiMessageStatus.getByValue(msg.getFieldAsInt32(baseId + 11L));
    }

    public long getId() {
        return this.id;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public AiMessageType getMessageType() {
        return this.messageType;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public long getSourceTaskId() {
        return this.sourceTaskId;
    }

    public String getSourceTaskType() {
        return this.sourceTaskType;
    }

    public long getRelatedObjectId() {
        return this.relatedObjectId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    public String getSpawnTaskData() {
        return this.spawnTaskData;
    }

    public AiMessageStatus getStatus() {
        return this.status;
    }

    public boolean isApprovalRequest() {
        return this.messageType == AiMessageType.APPROVAL_REQUEST;
    }

    public boolean isExpired() {
        return this.expirationTime.before(new Date());
    }

    public String toString() {
        return "AiMessage [id=" + this.id + ", guid=" + String.valueOf(this.guid) + ", messageType=" + String.valueOf((Object)this.messageType) + ", creationTime=" + String.valueOf(this.creationTime) + ", expirationTime=" + String.valueOf(this.expirationTime) + ", sourceTaskId=" + this.sourceTaskId + ", sourceTaskType=" + this.sourceTaskType + ", relatedObjectId=" + this.relatedObjectId + ", title=" + this.title + ", text=" + this.text + ", spawnTaskData=" + this.spawnTaskData + ", status=" + String.valueOf((Object)this.status) + "]";
    }
}

