/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AgentCacheMode {
    DEFAULT(0),
    ON(1),
    OFF(2);

    private static Logger logger;
    private static Map<Integer, AgentCacheMode> lookupTable;
    private int value;

    private AgentCacheMode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AgentCacheMode getByValue(int value) {
        AgentCacheMode element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return DEFAULT;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(AgentCacheMode.class);
        lookupTable = new HashMap<Integer, AgentCacheMode>();
        for (AgentCacheMode element : AgentCacheMode.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

