/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import java.util.UUID;
import org.netxms.base.NXCPMessage;

public class EPPConflict {
    private Type type;
    private UUID ruleGuid;
    private boolean hasClientRule;
    private boolean hasServerRule;
    private UUID serverModifiedByGuid;
    private String serverModifiedByName;
    private long serverModificationTime;

    public EPPConflict(NXCPMessage msg, long baseId) {
        this.type = Type.fromValue(msg.getFieldAsInt32(baseId));
        this.ruleGuid = msg.getFieldAsUUID(baseId + 1L);
        this.hasClientRule = msg.getFieldAsBoolean(baseId + 2L);
        this.hasServerRule = msg.getFieldAsBoolean(baseId + 3L);
        if (this.hasServerRule) {
            this.serverModifiedByGuid = msg.getFieldAsUUID(baseId + 4L);
            this.serverModifiedByName = msg.getFieldAsString(baseId + 5L);
            this.serverModificationTime = msg.getFieldAsInt64(baseId + 6L);
        }
    }

    public Type getType() {
        return this.type;
    }

    public UUID getRuleGuid() {
        return this.ruleGuid;
    }

    public boolean hasClientRule() {
        return this.hasClientRule;
    }

    public boolean hasServerRule() {
        return this.hasServerRule;
    }

    public UUID getServerModifiedByGuid() {
        return this.serverModifiedByGuid;
    }

    public String getServerModifiedByName() {
        return this.serverModifiedByName;
    }

    public long getServerModificationTime() {
        return this.serverModificationTime;
    }

    public static enum Type {
        MODIFY(1),
        DELETE(2);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type fromValue(int value) {
            for (Type t : Type.values()) {
                if (t.value != value) continue;
                return t;
            }
            return MODIFY;
        }
    }
}

