/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import java.util.Date;
import org.netxms.base.NXCPMessage;

public class IncidentActivity {
    public static final int ACTIVITY_CREATED = 0;
    public static final int ACTIVITY_STATE_CHANGE = 1;
    public static final int ACTIVITY_ASSIGNED = 2;
    public static final int ACTIVITY_ALARM_LINKED = 3;
    public static final int ACTIVITY_ALARM_UNLINKED = 4;
    public static final int ACTIVITY_COMMENT_ADDED = 5;
    public static final int ACTIVITY_UPDATED = 6;
    private long id;
    private long incidentId;
    private Date timestamp;
    private long userId;
    private int activityType;
    private String oldValue;
    private String newValue;
    private String details;

    public IncidentActivity(NXCPMessage msg, long baseId) {
        this.id = msg.getFieldAsInt64(baseId);
        this.incidentId = msg.getFieldAsInt64(baseId + 1L);
        this.timestamp = new Date(msg.getFieldAsInt64(baseId + 2L) * 1000L);
        this.userId = msg.getFieldAsInt64(baseId + 3L);
        this.activityType = msg.getFieldAsInt32(baseId + 4L);
        this.oldValue = msg.getFieldAsString(baseId + 5L);
        this.newValue = msg.getFieldAsString(baseId + 6L);
        this.details = msg.getFieldAsString(baseId + 7L);
    }

    public static String getActivityTypeName(int type) {
        switch (type) {
            case 0: {
                return "Created";
            }
            case 1: {
                return "State Changed";
            }
            case 2: {
                return "Assigned";
            }
            case 3: {
                return "Alarm Linked";
            }
            case 4: {
                return "Alarm Unlinked";
            }
            case 5: {
                return "Comment Added";
            }
            case 6: {
                return "Updated";
            }
        }
        return "Unknown";
    }

    public long getId() {
        return this.id;
    }

    public long getIncidentId() {
        return this.incidentId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getUserId() {
        return this.userId;
    }

    public int getActivityType() {
        return this.activityType;
    }

    public String getActivityTypeName() {
        return IncidentActivity.getActivityTypeName(this.activityType);
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public String getDetails() {
        return this.details;
    }

    public String toString() {
        return "IncidentActivity [id=" + this.id + ", incidentId=" + this.incidentId + ", timestamp=" + String.valueOf(this.timestamp) + ", userId=" + this.userId + ", activityType=" + this.getActivityTypeName() + ", oldValue=" + this.oldValue + ", newValue=" + this.newValue + ", details=" + this.details + "]";
    }
}

