/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AMSystemType {
    NONE(0),
    SERIAL(1),
    IP_ADDRESS(2),
    MAC_ADDRESS(3),
    VENDOR(4),
    MODEL(5);

    private static Logger logger;
    private static Map<Integer, AMSystemType> lookupTable;
    private int value;

    private AMSystemType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AMSystemType getByValue(int value) {
        AMSystemType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return NONE;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(AMSystemType.class);
        lookupTable = new HashMap<Integer, AMSystemType>();
        for (AMSystemType element : AMSystemType.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

